<?php
/**
 * Aliases for extension ConfirmAccount
 *
 * @file
 * @ingroup Extensions
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'RequestAccount' => array( 'RequestAccount' ),
	'ConfirmAccounts' => array( 'ConfirmAccounts' ),
	'UserCredentials' => array( 'UserCredentials' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'RequestAccount' => array( 'طلب_حساب' ),
	'ConfirmAccounts' => array( 'تأكيد_الحساب' ),
	'UserCredentials' => array( 'شهادات_المستخدم' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'RequestAccount' => array( 'طلب_حساب' ),
	'ConfirmAccounts' => array( 'تأكيد_الحساب' ),
	'UserCredentials' => array( 'شهادات_اليوزر' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'RequestAccount' => array( 'একাউণ্ট_অনুৰোধ' ),
	'ConfirmAccounts' => array( 'একাউণ্ট_নিশ্চিত_কৰক' ),
);

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = array(
	'RequestAccount' => array( 'RequestAccount' ),
);

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = array(
	'RequestAccount' => array( 'Minta_akun' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'RequestAccount' => array( 'GoulennKont' ),
	'ConfirmAccounts' => array( 'KadarnaatKont' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'RequestAccount' => array( 'ZahtjevajRacun' ),
	'ConfirmAccounts' => array( 'PotvrdiRacun' ),
	'UserCredentials' => array( 'KorisnickePotvrde' ),
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = array(
	'RequestAccount' => array( '申請賬戶' ),
	'ConfirmAccounts' => array( '確認賬戶' ),
	'UserCredentials' => array( '用戶積分' ),
);

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = array(
	'RequestAccount' => array( 'Декъашхочун_дӀаяздар_деха' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'RequestAccount' => array( 'Benutzerkonto_beantragen' ),
	'ConfirmAccounts' => array( 'Benutzerkonto_bestätigen' ),
	'UserCredentials' => array( 'Benutzerangaben' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'RequestAccount' => array( 'HesabWaştış' ),
	'ConfirmAccounts' => array( 'HesabRaştkerdış' ),
	'UserCredentials' => array( 'ReferanséKarberan' ),
);

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'RequestAccount' => array( 'Póžedanje_na_konto' ),
	'ConfirmAccounts' => array( 'Konto_wobkšuśiś' ),
	'UserCredentials' => array( 'Wužywarske_pódaśa' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'RequestAccount' => array( 'ΑίτησηΛογαριασμού' ),
	'ConfirmAccounts' => array( 'ΕπιβεβαίωσηΛογαριασμού' ),
	'UserCredentials' => array( 'ΣυστάσειςΧρήστη' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'RequestAccount' => array( 'Peti_konton' ),
	'ConfirmAccounts' => array( 'Konfirmi_konton' ),
	'UserCredentials' => array( 'Datumoj_pri_uzantoj' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'RequestAccount' => array( 'Pedir_cuenta_de_usuario', 'PedirCuentaUsuario' ),
	'ConfirmAccounts' => array( 'Confirmar_cuentas' ),
	'UserCredentials' => array( 'Credenciales' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'RequestAccount' => array( 'درخواست_حساب' ),
	'ConfirmAccounts' => array( 'تایید_حساب‌ها' ),
	'UserCredentials' => array( 'شناسه_کاربری' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'RequestAccount' => array( 'Pyydä_käyttäjätunnusta' ),
	'ConfirmAccounts' => array( 'Varmista_käyttäjätunnus' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'RequestAccount' => array( 'Demander_un_compte', 'DemanderUnCompte' ),
	'ConfirmAccounts' => array( 'ConfirmerCompte', 'Confirmation_compte', 'ConfirmationCompte' ),
);

/** Franco-Provençal (arpetan) */
$specialPageAliases['frp'] = array(
	'RequestAccount' => array( 'Demandar_un_compto', 'DemandarUnCompto' ),
	'ConfirmAccounts' => array( 'Confirmar_lo_compto', 'ConfirmarLoCompto', 'Confirmacion_de_compto', 'ConfirmacionDeCompto' ),
	'UserCredentials' => array( 'Refèrences_a_l\'usanciér', 'RefèrencesALUsanciér' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'RequestAccount' => array( 'Solicitar_unha_conta' ),
	'ConfirmAccounts' => array( 'Confirmar_a_conta' ),
	'UserCredentials' => array( 'Credenciais_de_usuario' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'RequestAccount' => array( 'Aatrag_stelle_fir_e_Benutzerchonto' ),
	'ConfirmAccounts' => array( 'Benutzerchonto_bstetige' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'RequestAccount' => array( 'בקשת_חשבון' ),
	'ConfirmAccounts' => array( 'אישור_חשבונות' ),
	'UserCredentials' => array( 'פרטי_משתמש' ),
);

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = array(
	'RequestAccount' => array( 'Zatraži_račun' ),
	'ConfirmAccounts' => array( 'Potvrdi_račun' ),
	'UserCredentials' => array( 'Suradničke_vjerodajnice' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'RequestAccount' => array( 'Konto_požadać' ),
	'ConfirmAccounts' => array( 'Konto_potwjerdźić' ),
	'UserCredentials' => array( 'Wužywarske_podaća' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'RequestAccount' => array( 'MandKont' ),
	'ConfirmAccounts' => array( 'KonfimeKont' ),
	'UserCredentials' => array( 'DwaItilizatèYo' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'RequestAccount' => array( 'Felhasználói_fiók_igénylése' ),
	'ConfirmAccounts' => array( 'Felhasználói_fiók_megerősítése' ),
	'UserCredentials' => array( 'Felhasználói_ajánlólevél' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'RequestAccount' => array( 'Requestar_conto' ),
	'ConfirmAccounts' => array( 'Confirmar_contos' ),
	'UserCredentials' => array( 'Referentias_del_usator' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'RequestAccount' => array( 'Minta_akun', 'MintaAkun' ),
	'ConfirmAccounts' => array( 'Konfirmasi_akun', 'KonfirmasiAkun' ),
	'UserCredentials' => array( 'Kredensial_pengguna', 'KredensialPengguna' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'RequestAccount' => array( 'RichiediUtenza' ),
	'ConfirmAccounts' => array( 'ConfermaUtenza' ),
	'UserCredentials' => array( 'CredenzialiUtente' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'RequestAccount' => array( 'アカウント申請', 'アカウント登録申請' ),
	'ConfirmAccounts' => array( 'アカウント承認', 'アカウントの承認', 'アカウント申請の承認', 'アカウント登録申請の承認' ),
	'UserCredentials' => array( '利用者信頼情報' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'ConfirmAccounts' => array( 'ანგარიშის_დადასტურება' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'RequestAccount' => array( 'ស្នើសុំគណនី' ),
	'ConfirmAccounts' => array( 'បញ្ជាក់ទទួលស្គាល់គណនី' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'RequestAccount' => array( '계정요청' ),
	'ConfirmAccounts' => array( '계정인증', '계정승인' ),
	'UserCredentials' => array( '계정자격증명' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'RequestAccount' => array( 'Metmaacherzohjang_beaandraare' ),
	'ConfirmAccounts' => array( 'Metmaacherzohjang_beshtätejje' ),
	'UserCredentials' => array( 'Metmaache-Aanjabe' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'RequestAccount' => array( 'GovynAkont' ),
	'ConfirmAccounts' => array( 'AfydhyaAkontow' ),
	'UserCredentials' => array( 'ManylyonAnDevnydhyer' ),
);

/** Ladino (Ladino) */
$specialPageAliases['lad'] = array(
	'RequestAccount' => array( 'Demandar_cuento_de_usador' ),
	'ConfirmAccounts' => array( 'AverdadearCuentos' ),
	'UserCredentials' => array( 'Letra_de_creença_de_usadores' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'RequestAccount' => array( 'Benotzerkont_ufroen' ),
	'ConfirmAccounts' => array( 'Benotzerkont_confirméieren' ),
	'UserCredentials' => array( 'Benotzerinformatiounen' ),
);

/** Malagasy (Malagasy) */
$specialPageAliases['mg'] = array(
	'RequestAccount' => array( 'Hangataka_kaonty', 'HangatakaKaonty' ),
	'ConfirmAccounts' => array( 'Hanamarina_kaonty', 'HanamarinaKaonty' ),
);

/** Minangkabau (Baso Minangkabau) */
$specialPageAliases['min'] = array(
	'RequestAccount' => array( 'PamintaanAkun' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'RequestAccount' => array( 'ПобарајКорисничкаСметка' ),
	'ConfirmAccounts' => array( 'ПотврдаНаКорисничкаСметка' ),
	'UserCredentials' => array( 'КорисничкиАкдредитиви' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'RequestAccount' => array( 'അംഗത്വം_ആവശ്യപ്പെടുക' ),
	'ConfirmAccounts' => array( 'അംഗത്വം_സ്ഥിരീകരിക്കുക' ),
	'UserCredentials' => array( 'ഉപയോക്തൃയോഗ്യത' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'RequestAccount' => array( 'खातेविनंती' ),
	'ConfirmAccounts' => array( 'खातेनिश्चिती' ),
	'UserCredentials' => array( 'सदस्यपरिचयप्त्र' ),
);

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = array(
	'ConfirmAccounts' => array( 'Sahkan_akaun', 'Mengesahkan_akaun' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'RequestAccount' => array( 'RikjestaKont' ),
	'ConfirmAccounts' => array( 'KonfermaKont' ),
	'UserCredentials' => array( 'KredenzjaliUtent' ),
);

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = array(
	'RequestAccount' => array( 'Etterspør_konto' ),
	'ConfirmAccounts' => array( 'Bekreft_konto' ),
	'UserCredentials' => array( 'Brukerlegitimasjon' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'RequestAccount' => array( 'Gebruker_anvragen' ),
	'ConfirmAccounts' => array( 'Gebruker_bevestigen' ),
	'UserCredentials' => array( 'Gebrukersgetuugschrift' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'RequestAccount' => array( 'GebruikerAanvragen' ),
	'ConfirmAccounts' => array( 'GebruikerBevestigen' ),
	'UserCredentials' => array( 'Gebruikersattest' ),
);

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = array(
	'RequestAccount' => array( 'Be_om_konto' ),
	'ConfirmAccounts' => array( 'Stadfest_kontoar' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'RequestAccount' => array( 'DemandarUnCompte', 'Demandar_un_compte' ),
	'ConfirmAccounts' => array( 'ConfirmarCompte', 'Confirmacion_compte', 'ConfirmacionCompte' ),
);

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = array(
	'RequestAccount' => array( 'ਖਾਤੇ_ਦੀ_ਬੇਨਤੀ_ਕਰੋ' ),
	'ConfirmAccounts' => array( 'ਖਾਤੇ_ਤਸਦੀਕ_ਕਰੋ' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'RequestAccount' => array( 'Prośba_o_utworzenie_konta' ),
	'ConfirmAccounts' => array( 'Potwierdzenie_konta' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'RequestAccount' => array( 'Pedir_conta' ),
	'ConfirmAccounts' => array( 'Confirmar_contas' ),
	'UserCredentials' => array( 'Credenciais_de_utilizador' ),
);

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'ConfirmAccounts' => array( 'Confirmar_conta' ),
	'UserCredentials' => array( 'Credenciais_de_usuário' ),
);

/** Romanian (română) */
$specialPageAliases['ro'] = array(
	'RequestAccount' => array( 'Cerere_cont' ),
	'ConfirmAccounts' => array( 'Confirmă_conturi' ),
	'UserCredentials' => array( 'Detalii_utilizator' ),
);

/** Russian (русский) */
$specialPageAliases['ru'] = array(
	'RequestAccount' => array( 'Запросить_учётную_запись' ),
);

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = array(
	'RequestAccount' => array( 'उपयोजकसंज्ञाविनन्ती' ),
	'ConfirmAccounts' => array( 'उपयोजकसंज्ञापुष्टिकरोति' ),
	'UserCredentials' => array( 'उपयोजकविश्वासपत्त्र' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'RequestAccount' => array( 'RichiediAccount' ),
	'ConfirmAccounts' => array( 'ConfermaAccount' ),
	'UserCredentials' => array( 'CredenzialiUtente' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'RequestAccount' => array( 'PožiadaťOÚčet' ),
	'ConfirmAccounts' => array( 'PotvrdiťÚčty' ),
	'UserCredentials' => array( 'PrihlasovacieÚdaje' ),
);

/** Albanian (shqip) */
$specialPageAliases['sq'] = array(
	'RequestAccount' => array( 'KërkoLlogari' ),
	'ConfirmAccounts' => array( 'KonfirmoLlogaritë' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'RequestAccount' => array( 'Begär_konto' ),
	'ConfirmAccounts' => array( 'Bekräfta_konto' ),
	'UserCredentials' => array( 'Användarnamn_och_lösenord' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'RequestAccount' => array( 'OmbaAkaunti' ),
	'ConfirmAccounts' => array( 'ThibitishaAkaunti' ),
);

/** Thai (ไทย) */
$specialPageAliases['th'] = array(
	'ConfirmAccounts' => array( 'ยืนยันบัญชีผู้ใช้' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'RequestAccount' => array( 'Hilingin_ang_kuwenta', 'HilingKuwenta' ),
	'ConfirmAccounts' => array( 'Tiyakin_ang_mga_kuwenta' ),
	'UserCredentials' => array( 'Mga_katibayan_ng_katangian_ng_tagagamit' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'RequestAccount' => array( 'Hesapİste' ),
	'ConfirmAccounts' => array( 'HesaplarıDoğrula' ),
	'UserCredentials' => array( 'KullanıcıReferansları' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'RequestAccount' => array( 'Запит_облікового_запису' ),
);

/** Urdu (اردو) */
$specialPageAliases['ur'] = array(
	'ConfirmAccounts' => array( 'تصدیق_کھاتہ_جات' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'RequestAccount' => array( 'Yêu_cầu_tài_khoản' ),
	'ConfirmAccounts' => array( 'Xác_nhận_tài_khoản' ),
);

/** Yiddish (ייִדיש) */
$specialPageAliases['yi'] = array(
	'RequestAccount' => array( 'בעטן_קאנטע' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'RequestAccount' => array( '申请账户' ),
	'ConfirmAccounts' => array( '确认账户' ),
	'UserCredentials' => array( '用户凭据' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'RequestAccount' => array( '請求帳號' ),
	'ConfirmAccounts' => array( '確認帳號' ),
	'UserCredentials' => array( '使用者憑證' ),
);