<?
class HtmlCleaner {
	// $linkRegex = "@(?:\s|^)(?:https?:\/\/|mailto:)(\S+)\b@";
	var $linkRegex = '{\\b((https?://|mailto:)([\\w/\\#:.?+=&%@!\\-]+?))(?=[.:?\\-]*(?:[^\\w/\\#:.?+=&%@!\\-]|$))}i';
	                 //'{\\b((https?|mailto):[\\w/\\#:.?+=&%@!\\-]+?)(?=[.:?\\-]*(?:[^\\w/\\#:.?+=&%@!\\-]|$))}';
	var $boldRegex = '{@B\[([^\]]+)\]}i';
	var $italRegex = '{@I\[([^\]]+)\]}i';
	var $bolditalRegex = '{@BI\[([^\]]+)\]}i';	// bold + italic
	var $detectTags = true;
	
	function printHtml($text) {
		$text = htmlspecialchars($text);
		if ($this->detectTags) {
			$text = preg_replace($this->linkRegex, "<a href=\"$1\">$3</a>", $text);
			$text = preg_replace($this->boldRegex, "<strong>$1</strong>", $text);
			$text = preg_replace($this->italRegex, "<em>$1</em>", $text);
			$text = preg_replace($this->bolditalRegex, "<strong><em>$1</em></strong>", $text);
		}
		return $text;
	}
}
	
	if ($_SERVER["REQUEST_METHOD"] == "POST") {
		$c = new HtmlCleaner();
		$text = $_POST["plaintext"];
		$text = $c->printHtml($text);
		print($text);
		return;
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<title>tag finder</title>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
</head>

<body>
<h3>FUS Tag Tester</h3>
<pre>
Tags honored:

Bold text:   @B[<strong>this will be bold</strong>]
Italic text: @I[<em>this will be italic</em>]
Bold-Italic: @BI[<strong><em>this will be bold and italic</em></strong>]
http://      auto-detected
https://     auto-detected
mailto:      auto-detected
</pre>
<form action="tagtest.php" method="POST">
	<textarea name="plaintext" wrap="physical" rows="8" cols="64"></textarea>
	<br />
	<input type="submit" value="Submit Your Stuff">
</form>

</body>
</html>

