#! /usr/bin/perl

# @(#) apply-template.pl 
# Craig A. Smith  2003.05.23

# Template is split in two parts: header and footer.
# The TITLE, CONTNET, etc is preserved form origial file and
# merged with templates to produce new look output.


$head_file = "/home/e700838/scripts/fus/template/head.html";
$foot_file = "/home/e700838/scripts/fus/template/foot.html";

# Read input file from stdin into $a

while ( <> ) {
   $a = $a . $_;
}

$title = "";
$keywords = "";
$description = "";
$content = "";

if ($a =~ m#(<title.*?/title.*?>)#is){
	$title = $1;
}
if ($a =~ m#(<meta[^>]*?description[^>]*?>)#is){
        $description = $1 ;
}
if ($a =~ m#(<meta[^>]*?keywords[^>]*?>)#is){
	$keywords = $1;
}

# The first <table> is the top banner.
# The 2nd <table> holds 3 <td> cells.
# The first <td> holds the Nav menu (we'll fix up latter) 
# The 2nd <td> hold an empty spacer cell.
# The CONTENT starts in the 3rd <td> (which may hold another <table... tag).
#if ($a =~ m#.*?<table.*?>.*?<table.*?</td.*?</td.*?>.*?(<table.*)#is) {
if ($a =~ m#<body.*?>(.*?)</body.*?>#is) {
	$content = $1;
}
else {
	$content =  " ######### ERROR No Content Found #############################";
}


#######  FOR DEBUGGING #########
=commnet
print " ------TITLE---------------- \n \n";
print $title, "\n\n";
print " ------KEYWORDS---------------- \n \n";
print $keywords, "\n\n";
print " ------DESCRIPTION---------------- \n \n";
print $description,  "\n\n";
print "-------- EXTRACTED CONTENT-------------\n";
print $content;
#print "-------- STRIPPED FOOTER -------------\n";
#print $out;
print "-------------------------------------------------------------\n";
=cut


########################################################
#    Special Fix-ups
########################################################

# 58 files lacking <body> or </body>
# these were manually edited

# 32 files had old "Return to Home Page" link.  Replace
$content =~ s#<a href.{1,20}openingpage\.html.{1,15}>#<a href="/">#gis;

# 171 links with target to main frame.  Eliminate
$content =~ s#(<a href.{1,50})target="main"(.{0,50}>)#$1 $2#gis;

# Someone's been using Windows' bastardized ISO char set for
# smart quotes.  Appear as ?/Diamond in browser or   in vi.
$content =~ s##'#gs;
$content =~ s##'#gs;
$content =~ s##'#gs;
$content =~ s##'#gs;
$content =~ s##"#gs;
$content =~ s##"#gs;
$content =~ s##...#gs;
$content =~ s## - #gs;




# Read template into $head
open TEMPLATE, $head_file;
while (<TEMPLATE>) {
   $head=$head.$_;
}
close TEMPLATE;


# Substute in preseved data
$head =~ s#<title.*?\/title.*?>#$title#eis;
$head =~ s#<meta\sname="keywords".*?>#$keywords#eis;
$head =~ s#<meta\sname="description".*?>#$description#eis;


open FOOT, $foot_file;
while ( <FOOT> ) {
   $foot=$foot.$_;
}
close FOOT;

$replacement = "$head\n\n$content\n\n$foot";



=commnet
print "--------PRESERVED DATA SUBSTITUTED INTO TEMPLATE-------------\n";
print $replacement;
print "-------------------------------------------------------------\n";
=cut



# Output final result to Stdout
print $replacement;


