<?
	require("../include/Auth.class.php");
	require("../include/login_check.php");
	require("../include/Properties.class.php");
	
	$logins = new Properties("data/login.xml");
	if ($logins->parseFailed()) {
		;
	}
	
	$method = strtolower($_SERVER["REQUEST_METHOD"]);
	if ($method == "get") {				// show password screen
		if (! isset($_SESSION["auth"])) {					// not logged in
			header("Location: index.php");
			return;
		}
		$auth = $_SESSION["auth"];
		$wildcard = $auth->GetChallengeText();
	}
	else if ($method == "post") {		// process password change
		if (! isset($_SESSION["auth"])) {					// not logged in
			header("Location: index.php");
			return;
		}
		$auth = $_SESSION["auth"];
		$password = LookupPassword($_POST["username"], $logins);
			// confirm current password
		if (! $auth->Authenticate($password, $_POST["hash"])) {
			header("Location: loginfailure.html");				// redirect to error page
			return;
		}
			// check new password == confirmation
		if ($_POST["newpassword"] != $_POST["confirmation"]) {
			header("Location: passwordfailure.html");				// redirect to error page
			return;
		}
			// update password file
		UpdatePassword($_POST["username"], $_POST["newpassword"], $logins);
		
		header("Location: passwordchanged.html");		// redirect to success page
		return;
	}
	
	function LookupPassword($user, $logins) {
		return $logins->getValue($user);
	}
	
	function UpdatePassword($user, $pass, $logins) {
		$logins->updateValue($user, $pass);
		$logins->save();
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<title>Change Password</title>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<link href="admin.css" rel="stylesheet" type="text/css" />
	<script src="../include/formverify.js" language="JavaScript1.1" type="text/javascript"></script>
	<script src="../include/Auth.class.js" language="JavaScript1.1" type="text/javascript"></script>
	<script language="JavaScript1.1" type="text/javascript">
		function hashAll(loginform) {
			var a = new AuthSHA1();
			loginform.newpassword.value = a.Hash(loginform.newpassword.value);
			loginform.confirmation.value = a.Hash(loginform.confirmation.value);
			return LoginSHA1(loginform);
		}
	</script>
</head>

<body>
<div align="center">
	<h2>Change Password</h2>
	<form name="pw" method="POST" onsubmit="
	    this.username.required = true;
	    this.newpassword.required = true;
	    this.confirmation.required = true;
	    return verify(this);
	">
		<input type="hidden" name="wildcard" value="<? echo htmlspecialchars($wildcard) ?>" />
		<input type="hidden" name="hash" />
	<table>
		<tr><th>Username</th><td><input type="text" name="username"></td></tr>
		<tr><th>Old Password</th><td><input type="password" name="password"></td></tr>
		<tr><td>&nbsp;</td></tr>
		<tr><th>New Password</th><td><input type="password" name="newpassword" title="New Password"></td></tr>
		<tr><th>Confirmation</th><td><input type="password" name="confirmation"></td></tr>
		<tr><td>&nbsp;</td></tr>
		<tr><td class="submit" colspan="2">
			<input type="submit" value="Change Password" onclick="return hashAll(document.pw)" />
			<input type="button" value="Cancel" onclick="history.go(-1)" />
		</td></tr>
	</table>
	</form>
</div>
</body>
</html>

