<?	/*
		Edit Levels
		-----------
		The system defines three levels of page editing rights for a logged-in user, each with it's own numeric value; 
		from highest to lowest they are ADMINISTRATOR_LEVEL (9), WEBMASTER_LEVEL (6), and EDITOR_LEVEL (3). The default 
		system predefines three users, one for each level of access, in the accounts.xml file. System installers may 
		define custom user levels, with numeric values between 0 and 9 (numbers outside this range may cause trouble.)
		
		Editor access to the web pages is controlled by the $pagelevels data structure. Within this array, a minimum 
		access level for each page is defined. New pages added to the site may be added to this array to control access. 
		Access level defaults to ADMINISTRATOR_LEVEL unless otherwise specified in $pagelevels.
		
		For example, the page 'contactus.php' requires WEBMASTER_LEVEL editing access or higher. The predefined 
		'admin' account, level 9, and the predefined 'webmaster' account, level 6, are allowed to edit 'contactus.php', 
		but the predefined 'editor' account, level 3, is not.
		
		Weaknesses
		----------
		At this time the access level setting is only used to control the appearance or non-appearance of the 
		'EDIT' buttons on the web pages. There is nothing to prevent a knowledgable EDITOR_LEVEL user from hacking 
		into pages reserved for higher levels. A future version of the system will implement editor security at the 
		data file level to eliminate this possibility.
	*/
	
	define("ADMINISTRATOR_LEVEL", 9);
	define("WEBMASTER_LEVEL", 6);
	define("EDITOR_LEVEL", 3);
	
	$pageLevels = array(
		'index.php' => ADMINISTRATOR_LEVEL, 
		'contactus.php' => WEBMASTER_LEVEL, 
		'getinvolved.php' => EDITOR_LEVEL, 
		'aboutus.php' => WEBMASTER_LEVEL, 
		'newcomers.php' => EDITOR_LEVEL, 
		'youth.php' => EDITOR_LEVEL, 
		'news.php' => EDITOR_LEVEL
	);
?>