<?	// SecuredLogin 1.0 - for performing server-side authentication of passwords hashed on the client side
	
	class SecuredLogin {
		var $__wildcard;
		
		function SecuredLogin() {
			;
		}
		function GetWildcard() {
			$this->__wildcard = $this->__generateNewWildcard();
			return $this->__wildcard;
		}
		
		// Approve() expects
		//		a $userSubmittedPassword in the form HashSHA1(wildcard + HashSHA1(userTypedPassword)),
		//			both hashing operations to be performed client-side; and
		//		a $lookedUpPassword in the form HashSHA1(userPassword), hashing performed at the time of original storage
		
		function Approve($userSubmittedPassword, $lookedUpPassword) {
			$sentWildcard = $this->__wildcard;
			$this->__wildcard = $this->__generateNewWildcard();
			return ($this->__hashSHA1($sentWildcard.$lookedUpPassword) == $userSubmittedPassword);
		}
		
		// ApproveClear() expects
		//		a $userSubmittedPassword in clear text; and
		//		a $lookedUpPassword in the form HashSHA1(userPassword), hashing performed at the time of original storage
		
		function ApproveClear($userSubmittedPassword, $lookedUpPassword) {
			$this->__wildcard = $this->__generateNewWildcard();
			return ($this->__hashSHA1($userSubmittedPassword) == $lookedUpPassword);
		}
		
		function __generateNewWildcard() {
			return $this->__hashSHA1(time());
		}
		
		function Hash($plaintext) {
			return __hashSHA1($plaintext);
		}
		
		function __hashSHA1($plaintext) {
			$hashtext = sha1($plaintext);
			return strtoupper($hashtext);
		}
	}
?>