<?	// copyright (C) 2005 - Matt Newberry, matt@mattnewberry.net
	// ALL RIGHTS RESERVED, except as site-licensed under contract
	
	/*  A Picture is a simple data structure containing an image filename and caption, width an height information, 
		and an optional url.
		
		Public Interface:
		
				//-- constructor ---------------
			
			function Picture($filename);
				- creates a Picture object from an XML datafile; $filename should be a full path 
					relative to the executing script directory
			
				//-- display functions ---------------
			
			function printPageTitle();
				- prints an identifying string, html-encoded, for an instance of this class (from XmlSimpleBaseClass)
			
			function getFilename();
			
			function printFilename();
			
			function printWidth();
			
			function printHeight();
			
			function printCaption();
			
			function printUrl();
			
				//-- error handling ---------------
			
			function parseFailed();
				- returns false if the Picture was successfully parsed from xml, otherwise true (from XmlSimpleBaseClass)
			
			function getParseError();
				- returns error code from the PHP xml parser; 0 if no error, 8001 if input file not found 
					or not readable (from XmlSimpleBaseClass)
			
			function printParseMessage();
				- prints error message from the PHP xml parser, html-encoded (from XmlSimpleBaseClass)
			
				//-- admin functions ---------------
			
			function populate($filename, $width, $height, $caption, $url);
			
			function getWidth();
			
			function getHeight();
			
			function save();
				- save data back to disk under original filename (from XmlSimpleBaseClass)
		
		
		Typical usage in HTML display context:
		
			$picture = new Picture("data/picture.xml");
			if (! $picture->parseFailed()) {
				<img src="$picture->printFilename()" width="$picture->printWidth()" height="$picture->printHeight()" />;
				$picture->printCaption();
			}
		
		
		XML Data Format:
		
			<picture>
				<pagetitle>TEXT</pagetitle>
				<filename>TEXT</filename> 
				<width>NUMBER</width> 
				<height>NUMBER</height> 
				<caption>TEXT</caption> 
				<url>TEXT</url>
			</picture>	
	*/
	require_once("XmlSimpleBaseClass.class.php");
	
	class Picture extends XmlSimpleBaseClass {
		var $xml_filename;
		var $xml_width;
		var $xml_height;
		var $xml_caption;
		var $xml_url;
		
		function Picture($filename) {
			$this->XmlSimpleBaseClass($filename);
		}
		
		function _p_cdata($parser, $text) {
			switch ($this->_tag) {
				case "filename":
					$this->xml_filename .= $text;
					break;
				case "width":
					$this->xml_width .= $text;
					break;
				case "height":
					$this->xml_height .= $text;
					break;
				case "caption":
					$this->xml_caption .= $text;
					break;
				case "url":
					$this->xml_url .= $text;
					break;
				case "pagetitle":
					$this->xml_pagetitle .= $text;
					break;
			}
		}
		
				// decode entities as character data
		function _p_default($parser, $ent) {
			$this->_p_cdata($parser, html_entity_decode($ent));
		}
		
		function populate($filename, $width, $height, $caption, $url) {
			$this->xml_filename = $filename;
			$this->xml_width = $width;
			$this->xml_height = $height;
			$this->xml_caption = $caption;
			$this->xml_url = $url;
		}
		
		function getFilename() {
			return $this->xml_filename;
		}
		
		function printFilename() {
			print htmlspecialchars($this->xml_filename);
		}
		
		function printWidth() {
			print htmlspecialchars($this->xml_width);
		}
		
		function printHeight() {
			print htmlspecialchars($this->xml_height);
		}
		
		function printCaption() {
			print htmlspecialchars($this->xml_caption);
		}
		
		function printUrl() {
			print htmlspecialchars($this->xml_url);
		}
		
		function getWidth() {
			return intval($this->xml_width);
		}
		
		function getHeight() {
			return intval($this->xml_height);
		}
	}
?>