<?	// copyright (C) 2007 - Matt Newberry, matt@mattnewberry.net
	// all rights reserved, except as licensed under contract
	
	/*  An Accounts is a container for an array of Login objects
		
		XML Data Format:
		
			<accounts>
				<login>
					<username>TEXT</username>
					<password>HASHED_TEXT</password>
					<level>INTEGER</level>
				</login>
					.
					.
					.
			</accounts>
	*/
	
	require_once("XmlSimpleBaseClass.class.php");
	
	class Accounts extends XmlSimpleBaseClass {
		var $_login;
		var $xml_logins = array();
		var $_count = 0;
		
		function Accounts($filename) {
			$this->XmlSimpleBaseClass($filename);
			$this->_count = count($this->xml_logins);
		}
		
		function _p_start_element($parser, $element, $attributes) {	// was &$attributes
		 	parent::_p_start_element($parser, $element, $attributes);	// was &$attributes
		 	if ($element == "login") {
				$this->_login = new Login();
			}
		}
		
		function _p_cdata($parser, $text) {
			switch ($this->_tag) {
				case "username":
					$this->_login->xml_username .= $text;
					break;
				case "password":
					$this->_login->xml_password .= $text;
					break;
				case "level":
					$this->_login->xml_level .= $text;
					break;
			}
		}
		
				// decode entities as character data
		function _p_default($parser, $ent) {
			$this->_p_cdata($parser, html_entity_decode($ent));
		}
		
		 function _p_end_element($parser, $element) {
		 	parent::_p_end_element($parser, $element);
		 	static $count = 0;
		 	if ($element == "login") {
				$this->_login->_index = $count;
				$this->xml_logins[$this->_login->getUserName()] = $this->_login;
			}
		 }
		
		function getLogin($username) {
			if (array_key_exists($username, $this->xml_logins))
				return $this->xml_logins[$username];
			else
				return null;
		}
		
		function updatePassword($user, $pass) {
			if (array_key_exists($user, $this->xml_logins))
				$this->xml_logins[$user]->setPassword($pass);
		}
	}
	
	class Login {
		var $xml_username;
		var $xml_password;
		var $xml_level;
		var $_index;
		
		function Login() {
			;
		}
		
		function getUserName() {
			return $this->xml_username;
		}
		
		function getPassword() {
			return $this->xml_password;
		}
		
		function getLevel() {
			if (is_numeric($this->xml_level))
				return intval($this->xml_level);
			else
				return -1;
		}
		
		function setPassword($pass) {
			$this->xml_password = $pass;
		}
	}
?>
