<?
function userIsLoggedIn() {
	if (! isset($_SESSION['logged_in']))
		return false;
   return $_SESSION['logged_in'];
}

function userCanEdit() {
	if (! userIsLoggedIn())
		return false;
	$userLevel = $_SESSION['access_level'];
	$pageLevels = $_SESSION['page_levels'];
	$pageFilename = $_SERVER['PHP_SELF'];
	$pageFilename = basename($pageFilename);
	$requiredLevel = $pageLevels[$pageFilename];
	$requiredLevel = $requiredLevel == null ? 9 : $requiredLevel;
	if ($userLevel >= $requiredLevel)
		return true;
	else
		return false;
}

function printTextBlock($filename) {
   $textblock = new TextBlock($filename);
   
   if(!is_readable($filename)) {
      print "\n<!-- ERR: file '$filename' is not readable -->\n";
      return $textblock;
   }

   if (!$textblock->parseFailed()) {
      print "<H2>";
      $textblock->printHeadline();
      print "</H2>";
      $image = $textblock->getImage();
      if($image) 
         print "<IMG ALIGN=right SRC=images/$image BORDER=0>";

      while ($textblock->moreParagraphs()) {
         $textblock->printNextParagraph();
         print "<P>";
      }
   }
 
   if(userIsLoggedIn()) {
      $EDIT_LINK = "admin/textblock.php?data=" . makeDataName($filename);
      echo "<P><A HREF='$EDIT_LINK'><img src='buttons/edit_button.gif' border='1'></A><P>";
   }

   return $textblock;
}

function printLeftSideMenu($filename = 0) {
   global $_TEMPL_CONFIG;
   
   $props = getSystemProperties();

   if($props->getValue("universalMenus")) {
      $filename = $_TEMPL_CONFIG['MENU_DATA']['UNIVERSAL'];
   } else {
      $SCRIPT = basename($_SERVER["SCRIPT_NAME"]);
      $filename = $_TEMPL_CONFIG['MENU_DATA'][$SCRIPT];
   }

   $menu = new Menu($filename);

   if (! $menu->parseFailed()) {
      while (($i = $menu->getNextMenuItem()) != null) {
         $i->printMenuItem();
         echo "<P>";
      }
   }

   if(userCanEdit()) {
      $LINK = "admin/menu.php?data=" . makeDataName($filename);
      echo "<A HREF='$LINK'><img src='buttons/edit_button.gif' border='1'></A><BR>";
   }
}

function printRightSideTextBlock() {
   global $_TEMPL_CONFIG;
   $SCRIPT = basename($_SERVER["SCRIPT_NAME"]);

   $filename = $_TEMPL_CONFIG['RIGHT_SIDE_DATA'][$SCRIPT];
   $textblock = new TextBlock($filename);

   print "";

   $image = $textblock->getImage();
   if($image) 
      print "<BR><IMG ALIGN=center SRC=images/$image BORDER=0><BR>";

   while ($textblock->moreParagraphs()) {
      $textblock->printNextParagraph();
      print "<P>";
   }

   if(userCanEdit()) {
      $LINK = "admin/textblock.php?data=" . makeDataName($filename);
      echo "<A HREF='$LINK'><img src='buttons/edit_button.gif' border='1'></A><BR>";
   }
}

function printCalendar($filename) {
   $calendar = new Calendar($filename);
   if (! $calendar->parseFailed()) {
      print "<TABLE>";
      while (($e = $calendar->getNextEvent()) != null) {
         echo "<TR VALIGN=top><TD WIDTH='30%'><B>"; $e->printDate(); echo "</B></TD>\n";
         echo "<TD>"; $e->printDescription(); echo "</TD></TR>\n";
      }
      print "</TABLE>";
   } else {
      print "Calendar parse failed.";
   }

   if(userCanEdit()) {
      $LINK  = "admin/calendar.php?data=" . makeDataName($filename);
      echo "<P><A HREF=$LINK><img src='buttons/edit_button.gif' border='1'></A>";
   }
}

function makeDataName($filename) {
   $filename = basename($filename);
   $filename = eregi_replace("\.xml$", "", $filename);
   return $filename;
}

function getSystemProperties() {
   global $_TEMPL_CONFIG;
   $props = new Properties($_TEMPL_CONFIG['PROPERTIES']);
   return $props;
}

?>
