<?	/*
		Password Changes
		----------------
		Any logged-in user may change his password from the admin menu. The process requires the user to re-enter 
		his current username and password. Upon form submission, the user is then re-authenticated using the same 
		hash-and-lookup procedure as described in login.php. In addition, the new password and its confirmation are 
		transmitted in SHA1 hashed format. Upon successful re-authentication, the new hashed password is stored 
		directly into the user's account information without server-side manipulation of any kind.
		
		Weaknesses
		----------
		Although the new password is transmitted over the wire in hashed format, not in clear text, an attacker who 
		is able to intercept the hashed password can subject it to a dictionary attack using a hashed list of common 
		passwords. Unless SSL is used, users should avoid changing their passwords over public wireless networks. 
		
		Note that this restriction does not apply to the login process, in which the password is doubly-hashed with 
		a non-repeating key, making it immune to dictionary attacks (see the login.php documentation). It is not possible 
		to transmit a password change in doubly-hashed format, because the single-hashed password must be available for 
		storage in the user's account. It may be possible to rework the login scheme to work around this issue, as well 
		as the missing 'salt' issue, as discussed in login.php.
	*/
	
	ini_set("display_errors", "1");
	require("../include/SecuredLogin.class.php");
	require("../include/login_check.php");
	require("../include/Accounts.class.php");
	
	if (! isset($_SESSION["SecuredLogin"]) || $_SESSION["SecuredLogin"] == null) {			// not logged in
		header("Location: index.php");
		return;
	}
	$security = $_SESSION["SecuredLogin"];
	
	$logins = new Accounts("data/accounts.xml");
	if ($logins->parseFailed()) {
		exit();
	}
	
	$method = strtolower($_SERVER["REQUEST_METHOD"]);
	if ($method == "get") {				// show password screen
		$wildcard = $security->GetWildcard();
	}
	else if ($method == "post") {		// process password change
		$password = LookupPassword($_POST["username"], $logins);
			// confirm current password
		if (! $security->Approve($_POST["hash"], $password)) {
			header("Location: loginfailure.html");				// redirect to error page
			return;
		}
			// check new password == confirmation
		if ($_POST["newpassword"] != $_POST["confirmation"]) {
			header("Location: passwordfailure.html");				// redirect to error page
			return;
		}
			// update password file
		UpdatePassword($_POST["username"], $_POST["newpassword"], $logins);
		
		header("Location: passwordchanged.html");		// redirect to success page
		return;
	}
	
	function LookupPassword($user, $logins) {
		$login = $logins->getLogin($user);
		if ($login != null)
			return $login->getPassword();
		else
			return '';
	}
	
	function UpdatePassword($user, $pass, $logins) {
		$logins->updatePassword($user, $pass);
		$logins->save();
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<title>Change Password</title>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<link href="admin.css" rel="stylesheet" type="text/css" />
	<script src="../include/SecuredLogin.class.js" language="JavaScript1.1" type="text/javascript"></script>
	<script type="text/javascript" language="JavaScript1.1">
		function formRequire(frm, usernameFieldname, passwordFieldname, newpassFieldname, confirmFieldname) {
			if (frm[usernameFieldname].value == '' || frm[passwordFieldname].value == '' || frm[newpassFieldname].value == '' || frm[confirmFieldname].value == '') {
				alert('Please enter your current username and password, and a new password with confirmation.');
				return false;
			}
			if (frm[newpassFieldname].value != frm[confirmFieldname].value) {
				alert('The new password and the confirmation do not match.');
				return false;
			}
			return true;
		}
		function approve(frm, passwordFieldname, hashpassFieldname, newpassFieldname, confirmFieldname) {
			var wildcard = "<? print($wildcard) ?>"
			var security = new SecuredLogin(wildcard);
			security.Secure(frm, passwordFieldname, hashpassFieldname)
			frm[newpassFieldname].value = security.Hash(frm[newpassFieldname].value);
			frm[confirmFieldname].value = security.Hash(frm[confirmFieldname].value);
			return true;
		}
	</script>
</head>

<body>
<div align="center">
	<h2>Change Password</h2>
	<form name="pw" method="POST" onsubmit="return approve(this, 'password', 'hash', 'newpassword', 'confirmation')">
		<input type="hidden" name="hash" />
	<table>
		<tr><th>Username</th><td><input type="text" name="username"></td></tr>
		<tr><th>Old Password</th><td><input type="password" name="password"></td></tr>
		<tr><td>&nbsp;</td></tr>
		<tr><th>New Password</th><td><input type="password" name="newpassword" title="New Password"></td></tr>
		<tr><th>Confirmation</th><td><input type="password" name="confirmation"></td></tr>
		<tr><td>&nbsp;</td></tr>
		<tr><td class="submit" colspan="2">
			<input type="submit" value="Change Password" onclick="return formRequire(document.pw, 'username', 'password', 'newpassword', 'confirmation')" />
			<input type="button" value="Cancel" onclick="history.go(-1)" />
		</td></tr>
	</table>
	</form>
</div>
</body>
</html>

