<?php
/* $Id: category_handler.php,v 1.33.2.3 2007/11/12 15:40:29 umcesrjones Exp $ */
include_once 'includes/init.php';

$icon_max_size = '3000';
$icon_path = 'icons/';

/* Rename any icons associated with this cat_id. */
function renameIcon ( $id ) {
  global $icon_path;
  $bakIcon = $catIcon = $icon_path . 'cat-';
  $bakIcon .= date ( 'YmdHis' ) . '.gif';
  $catIcon .= $id . '.gif';
  if ( file_exists ( $catIcon ) )
    rename ( $catIcon, $bakIcon );
}

// Does the category belong to the user?
$is_my_event = false;
if ( empty ( $id ) )
  $is_my_event = true; // New event.
else {
  $res = dbi_execute ( 'SELECT cat_id, cat_owner FROM webcal_categories
    WHERE cat_id = ?', array ( $id ) );
  if ( $res ) {
    $row = dbi_fetch_row ( $res );

    $is_my_event = ( $row[0] == $id && $row[1] == $login ||
      ( empty ( $row[1] ) && $is_admin ) );

    dbi_free_result ( $res );
  } else
    $error = db_error ();
}

if ( ! empty ( $_FILES['FileName'] ) )
  $file = $_FILES['FileName'];

// Make sure we clear $file if no file was upoaded.
if ( ! empty ( $file['tmp_name'] ) && $file['tmp_name'] == 'none' )
  $file = '';

if ( ! $is_my_event )
  $error = print_not_auth (5);

$delete = getPostValue ( 'delete' );
if ( empty ( $error ) && ! empty ( $delete ) ) {
  // Delete this category.
  if ( ! dbi_execute ( 'DELETE FROM webcal_categories
    WHERE cat_id = ? AND ( cat_owner = ?'
       . ( $is_admin ? ' OR cat_owner IS NULL )' : ' )' ),
        array ( $id, $login ) ) ) {
    $error = db_error ();
  }

  if ( ! dbi_execute ( 'DELETE FROM webcal_entry_categories
    WHERE cat_id = ? AND ( cat_owner = ?'
       . ( $is_admin ? ' OR cat_owner IS NULL )' : ' )' ),
        array ( $id, $login ) ) ) {
    $error = db_error ();
  }
  // Rename any icons associated with this cat_id.
  renameIcon ( $id );
} else if ( empty ( $error ) ) {
  if ( ! empty ( $id ) ) {
    # Update (don't let them change global status).
    if ( ! dbi_execute ( 'UPDATE webcal_categories
      SET cat_name = ?, cat_color = ? WHERE cat_id = ?',
        array ( $catname, $catcolor, $id ) ) )
      $error = db_error ();

    $delIcon = getPostValue ( 'delIcon' );
    if ( ! empty ( $delIcon ) && $delIcon == 'Y' )
      renameIcon ( $id );
  } else {
    // Add new category.
    // Get new id.
    $res = dbi_execute ( 'SELECT MAX( cat_id ) FROM webcal_categories' );
    if ( $res ) {
      $row = dbi_fetch_row ( $res );
      $id = $row[0] + 1;
      dbi_free_result ( $res );
      $catowner = ( $is_admin
        ? ( $isglobal == 'Y' ? null : $login )
        : $login );

      if ( ! dbi_execute ( 'INSERT INTO webcal_categories ( cat_id, cat_owner,
        cat_name, cat_color ) VALUES ( ?, ?, ?, ? )',
          array ( $id, $catowner, $catname, $catcolor ) ) )
        $error = db_error ();
    } else
      $error = db_error ();
  }
  if ( empty ( $delIcon ) && is_dir( $icon_path ) && ( !
        empty ( $ENABLE_ICON_UPLOADS ) && $ENABLE_ICON_UPLOADS == 'Y' ||
        $is_admin ) ) {
    // Save icon if uploaded.
    if ( ! empty ( $file['tmp_name'] ) ) {
      if ( $file['type'] == 'image/gif' && $file['size'] <= $icon_max_size ) {
        // $icon_props = getimagesize ( $file['tmp_name']  );
        // print_r ($icon_props );
        $path_parts = pathinfo ( $_SERVER['SCRIPT_FILENAME'] );
        $fullIcon = $path_parts['dirname'] . '/'
         . $icon_path . 'cat-' . $id . '.gif';
        renameIcon ( $id );
        $file_result = move_uploaded_file ( $file['tmp_name'], $fullIcon );
        // echo "Upload Result:" . $file_result;
      } else
      if ( $file['size'] > $icon_max_size )
        $error = translate ( 'File size exceeds maximum.' );
      else
      if ( $file['type'] != 'image/gif' )
        $error = translate ( 'File is not a gif image.' );
    }
    // Copy icon if local file specified.
    $urlname = getPostvalue ( 'urlname' );
    if ( ! empty ( $urlname ) && file_exists ( $icon_path . $urlname ) )
      copy ( $icon_path . $urlname, $icon_path . 'cat-' . $id . '.gif' );
  }
}

if ( empty ( $error ) )
  do_redirect ( 'category.php' );

print_header ();
echo print_error ( $error ) . print_trailer ();

?>
