<?php
/**
 * Aliases for extension ConfirmAccount
 *
 * @addtogroup Extensions
 */

$aliases = array();

/** English
 * @author Jon Harald Søby
 */
$aliases['en'] = array(
	'RequestAccount'  => array( 'RequestAccount' ),
	'ConfirmAccounts' => array( 'ConfirmAccounts' ),
	'UserCredentials' => array( 'UserCredentials' ),
);

/** Arabic (العربية) */
$aliases['ar'] = array(
	'RequestAccount' => array( 'طلب_حساب' ),
	'ConfirmAccounts' => array( 'تأكيد_الحساب' ),
	'UserCredentials' => array( 'شهادات_المستخدم' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$aliases['arz'] = array(
	'RequestAccount' => array( 'طلب_حساب' ),
	'ConfirmAccounts' => array( 'تأكيد_الحساب' ),
	'UserCredentials' => array( 'شهادات_المستخدم' ),
);

/** Bosnian (Bosanski) */
$aliases['bs'] = array(
	'RequestAccount' => array( 'ZahtjevajRacun' ),
	'ConfirmAccounts' => array( 'PotvrdiRacun' ),
	'UserCredentials' => array( 'KorisnickePotvrde' ),
);

/** German (Deutsch) */
$aliases['de'] = array(
	'RequestAccount' => array( 'Benutzerkonto beantragen' ),
	'ConfirmAccounts' => array( 'Benutzerkonto bestätigen' ),
	'UserCredentials' => array( 'Benutzerangaben' ),
);

/** Lower Sorbian (Dolnoserbski) */
$aliases['dsb'] = array(
	'RequestAccount' => array( 'Póžedanje na konto' ),
	'ConfirmAccounts' => array( 'Konto wobkšuśiś' ),
	'UserCredentials' => array( 'Wužywarske pódaśa' ),
);

/** Greek (Ελληνικά) */
$aliases['el'] = array(
	'RequestAccount' => array( 'ΑίτησηΛογαριασμού' ),
	'ConfirmAccounts' => array( 'ΕπιβεβαίωσηΛογαριασμού' ),
	'UserCredentials' => array( 'ΣυστάσειςΧρήστη' ),
);

/** Finnish (Suomi) */
$aliases['fi'] = array(
	'RequestAccount' => array( 'Pyydä käyttäjätunnusta' ),
	'ConfirmAccounts' => array( 'Varmista käyttäjätunnus' ),
);

/** French (Français) */
$aliases['fr'] = array(
	'RequestAccount' => array( 'Demander un compte', 'DemanderUnCompte' ),
	'ConfirmAccounts' => array( 'ConfirmerCompte', 'Confirmation compte', 'ConfirmationCompte' ),
);

/** Franco-Provençal (Arpetan) */
$aliases['frp'] = array(
	'RequestAccount' => array( 'Demandar un compto', 'DemandarUnCompto' ),
	'ConfirmAccounts' => array( 'Confirmar lo compto', 'ConfirmarLoCompto', 'Confirmacion de compto', 'ConfirmacionDeCompto' ),
	'UserCredentials' => array( "Refèrences a l'utilisator", 'RefèrencesALUtilisator' ),
);

/** Galician (Galego) */
$aliases['gl'] = array(
	'RequestAccount' => array( 'Solicitar unha conta' ),
	'ConfirmAccounts' => array( 'Confirmar a conta' ),
);

/** Swiss German (Alemannisch) */
$aliases['gsw'] = array(
	'RequestAccount' => array( 'Aatrag stelle fir e Benutzerchonto' ),
	'ConfirmAccounts' => array( 'Benutzerchonto bstetige' ),
);

/** Hebrew (עברית) */
$aliases['he'] = array(
	'RequestAccount' => array( 'בקשת_חשבון' ),
	'ConfirmAccounts' => array( 'אישור_חשבונות' ),
	'UserCredentials' => array( 'פרטי_משתמש' ),
);

/** Croatian (Hrvatski) */
$aliases['hr'] = array(
	'RequestAccount' => array( 'Zatraži_račun' ),
	'ConfirmAccounts' => array( 'Potvrdi_račun' ),
	'UserCredentials' => array( 'Suradničke_vjerodajnice' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$aliases['hsb'] = array(
	'RequestAccount' => array( 'Konto požadać' ),
	'ConfirmAccounts' => array( 'Konto potwjerdźić' ),
	'UserCredentials' => array( 'Wužywarske podaća' ),
);

/** Haitian (Kreyòl ayisyen) */
$aliases['ht'] = array(
	'ConfirmAccounts' => array( 'KonfimeKonpt' ),
);

/** Hungarian (Magyar) */
$aliases['hu'] = array(
	'RequestAccount' => array( 'Felhasználói fiók igénylése' ),
	'ConfirmAccounts' => array( 'Felhasználói fiók megerősítése' ),
	'UserCredentials' => array( 'Felhasználói ajánlólevél' ),
);

/** Interlingua (Interlingua) */
$aliases['ia'] = array(
	'RequestAccount' => array( 'Requestar conto' ),
	'ConfirmAccounts' => array( 'Confirmar contos' ),
	'UserCredentials' => array( 'Referentias del usator' ),
);

/** Indonesian (Bahasa Indonesia) */
$aliases['id'] = array(
	'RequestAccount' => array( 'Minta akun', 'MintaAkun' ),
	'ConfirmAccounts' => array( 'Konfirmasi akun', 'KonfirmasiAkun' ),
);

/** Italian (Italiano) */
$aliases['it'] = array(
	'UserCredentials' => array( 'CredenzialiUtente' ),
);

/** Japanese (日本語) */
$aliases['ja'] = array(
	'RequestAccount' => array( 'アカウント申請', 'アカウント登録申請' ),
	'ConfirmAccounts' => array( 'アカウント承認', 'アカウントの承認', 'アカウント申請の承認', 'アカウント登録申請の承認' ),
	'UserCredentials' => array( '利用者信頼情報' ),
);

/** Khmer (ភាសាខ្មែរ) */
$aliases['km'] = array(
	'RequestAccount' => array( 'ស្នើសុំគណនី' ),
	'ConfirmAccounts' => array( 'បញ្ជាក់ទទួលស្គាល់គណនី' ),
);

/** Korean (한국어) */
$aliases['ko'] = array(
	'RequestAccount' => array( '계정요청' ),
	'ConfirmAccounts' => array( '계정승인' ),
);

/** Ripoarisch (Ripoarisch) */
$aliases['ksh'] = array(
	'RequestAccount' => array( 'Metmaacherzohjang beaandraare' ),
	'ConfirmAccounts' => array( 'Metmaacherzohjang beshtätejje' ),
	'UserCredentials' => array( 'Metmaache-Aanjabe' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$aliases['lb'] = array(
	'RequestAccount' => array( 'Benotzerkont ufroen' ),
	'ConfirmAccounts' => array( 'Benotzerkont confirméieren' ),
	'UserCredentials' => array( 'Benotzerinformatiounen' ),
);

/** Macedonian (Македонски) */
$aliases['mk'] = array(
	'RequestAccount' => array( 'ПобарајКорисничкаСметка' ),
	'ConfirmAccounts' => array( 'ПотврдаНаКорисничкаСметка' ),
);

/** Malayalam (മലയാളം) */
$aliases['ml'] = array(
	'RequestAccount' => array( 'അംഗത്വം ആവശ്യപ്പെടുക' ),
	'ConfirmAccounts' => array( 'അംഗത്വം സ്ഥിരീകരിക്കുക' ),
);

/** Marathi (मराठी) */
$aliases['mr'] = array(
	'RequestAccount' => array( 'खातेविनंती' ),
	'ConfirmAccounts' => array( 'खातेनिश्चिती' ),
	'UserCredentials' => array( 'सदस्यपरिचयप्त्र' ),
);

/** Malay (Bahasa Melayu) */
$aliases['ms'] = array(
	'ConfirmAccounts' => array( 'Sahkan akaun', 'Mengesahkan akaun' ),
);

/** Maltese (Malti) */
$aliases['mt'] = array(
	'RequestAccount' => array( 'RikjestaKont' ),
	'ConfirmAccounts' => array( 'KonfermaKont' ),
	'UserCredentials' => array( 'KredenzjaliUtent' ),
);

/** Nedersaksisch (Nedersaksisch) */
$aliases['nds-nl'] = array(
	'RequestAccount' => array( 'Gebruker_anvragen' ),
	'ConfirmAccounts' => array( 'Gebruker_bevestigen' ),
	'UserCredentials' => array( 'Gebrukersgetuugschrif' ),
);

/** Dutch (Nederlands) */
$aliases['nl'] = array(
	'RequestAccount' => array( 'GebruikerAanvragen' ),
	'ConfirmAccounts' => array( 'GebruikerBevestigen' ),
	'UserCredentials' => array( 'Gebruikersattest' ),
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬) */
$aliases['no'] = array(
	'RequestAccount' => array( 'Etterspør konto' ),
	'ConfirmAccounts' => array( 'Bekreft konto' ),
	'UserCredentials' => array( 'Brukerlegitimasjon' ),
);

/** Occitan (Occitan) */
$aliases['oc'] = array(
	'RequestAccount' => array( 'DemandarUnCompte', 'Demandar un compte' ),
	'ConfirmAccounts' => array( 'ConfirmarCompte', 'Confirmacion compte', 'ConfirmacionCompte' ),
);

/** Portuguese (Português) */
$aliases['pt'] = array(
	'RequestAccount' => array( 'Pedir conta' ),
	'ConfirmAccounts' => array( 'Confirmar contas' ),
	'UserCredentials' => array( 'Credenciais de utilizador' ),
);

/** Brazilian Portuguese (Português do Brasil) */
$aliases['pt-br'] = array(
	'ConfirmAccounts' => array( 'Confirmar conta' ),
	'UserCredentials' => array( 'Credenciais de usuário' ),
);

/** Romanian (Română) */
$aliases['ro'] = array(
	'RequestAccount' => array( 'Cerere cont' ),
	'ConfirmAccounts' => array( 'Confirmă conturi' ),
	'UserCredentials' => array( 'Detalii utilizator' ),
);

/** Sanskrit (संस्कृत) */
$aliases['sa'] = array(
	'RequestAccount' => array( 'उपयोजकसंज्ञाविनन्ती' ),
	'ConfirmAccounts' => array( 'उपयोजकसंज्ञापुष्टिकरोति' ),
	'UserCredentials' => array( 'उपयोजकविश्वासपत्त्र' ),
);

/** Slovak (Slovenčina) */
$aliases['sk'] = array(
	'RequestAccount' => array( 'PožiadaťOÚčet' ),
	'ConfirmAccounts' => array( 'PotvrdiťÚčty' ),
	'UserCredentials' => array( 'PrihlasovacieÚdaje' ),
);

/** Albanian (Shqip) */
$aliases['sq'] = array(
	'RequestAccount' => array( 'KërkoLlogari' ),
	'ConfirmAccounts' => array( 'KonfirmoLlogaritë' ),
);

/** Swedish (Svenska) */
$aliases['sv'] = array(
	'ConfirmAccounts' => array( 'Bekräfta konto' ),
	'UserCredentials' => array( 'Användarnamn och lösenord' ),
);

/** Swahili (Kiswahili) */
$aliases['sw'] = array(
	'RequestAccount' => array( 'OmbaAkaunti' ),
	'ConfirmAccounts' => array( 'ThibitishaAkaunti' ),
);

/** Thai (ไทย) */
$aliases['th'] = array(
	'ConfirmAccounts' => array( 'ยืนยันบัญชีผู้ใช้' ),
);

/** Tagalog (Tagalog) */
$aliases['tl'] = array(
	'RequestAccount' => array( 'Hilingin ang kuwenta', 'HilingKuwenta' ),
	'ConfirmAccounts' => array( 'Tiyakin ang mga kuwenta' ),
	'UserCredentials' => array( 'Mga katibayan ng katangian ng tagagamit' ),
);

/** Turkish (Türkçe) */
$aliases['tr'] = array(
	'RequestAccount' => array( 'Hesapİste' ),
	'ConfirmAccounts' => array( 'HesaplarıDoğrula' ),
	'UserCredentials' => array( 'KullanıcıReferansları' ),
);

