<?	// copyright (C) 2005 - Matt Newberry, matt@mattnewberry.net
	// all rights reserved, except as licensed under contract

	define("AUTH_NOT_LOGGED_IN", 0);
	define("AUTH_SUCCESS", 1);
	define("AUTH_FAILED", 2);
	define("AUTH_TOO_MANY_TRIES", 3);
	define("AUTH_AUTHKEY_REVOKED", 4);

		// Auth - base login authentication class
		
	class Auth {
		var $tries, $maxtries;
		var $allowclear;
		var $challenge;
		var $authenticated;
		var $lastLoginResult;
	
		function Auth() {
			$this->tries = 0;
			$this->maxtries = 2000000000;
			$this->authenticated = false;
			$this->lastLoginResult = AUTH_NOT_LOGGED_IN;
			$this->challenge = $this->NewChallengeString();
		}
		
		function NewChallengeString() {
			$idsize = rand(24, 32);
			$ssid = "";
			for ($i = 0; $i < $idsize; ++$i) {
				$ch = rand(65, 122);
				if ($ch > 90 && $ch < 97)
					$ch = '_';
				$ssid .= $ch;
			}
			return $this->Hash($ssid);
		}
		
		function SetMaxTries($value) {
			$this->maxtries = $value;
		}
		
		function GetChallengeText() {
			return $this->challenge;
		}
		
		function IsAuthenticated() {
			return $this->authenticated;
		}
		
		function GetLastLoginResult() {
			return $this->lastLoginResult;
		}
		
		function Authenticate($password, $hashstring) {
			if (++$this->tries > $this->maxtries) {
				$this->lastLoginResult = AUTH_TOO_MANY_TRIES;
				return false;
			}
			if ($this->challenge == null) {
				$this->lastLoginResult = AUTH_AUTHKEY_REVOKED;
				return false;
			}
			if ($hashstring == $this->Hash($this->challenge.$password) /* js encrypted */
					|| ($this->allowclear && $hashstring == $password) /* js not enabled? */) {
				$this->challenge = $this->NewChallengeString();
				$this->authenticated = true;
				$this->lastLoginResult = AUTH_SUCCESS;
				return true;
			}
			else {
				$this->lastLoginResult = AUTH_FAILED;
				return false;
			}
		}
		
		function Logout() {
			$this->tries = 0;
			$this->authenticated = false;
			$this->lastLoginResult = AUTH_NOT_LOGGED_IN;
		}
	}

		// AuthMD5 - low security login class: password stored as clear text & may be sent clear
		
	class AuthMD5 extends Auth {
	
		function AuthMD5() {
			$this->Auth();
			$this->allowclear = true;
		}
		
		function Hash($source) {
			return strtoupper(md5($source));
		}
	}

		// AuthSHA1 - higher security login class: password stored hashed & must be sent hashed
		
	class AuthSHA1 extends Auth {
	
		function AuthSHA1() {
			$this->Auth();
			$this->allowclear = false;
		}
		
		function Hash($source) {
				// php 4.3+
			return strtoupper(sha1($source));
				// early php
			// $sha1 = new SHA1_Tool();
			// return strtoupper($sha1->calcSHA1($source));
		}
	}
		
		// ------------ privates ------------------------
	
	class SHA1_Tool {	// needed for PHP version < 4.30
    /*
     * SHA-1
     * A PHP implementation of the Secure Hash Algorithm, SHA-1, 
     * based on the JavaScript implementation by Paul Johnston. 
     * This is basically a "translation from JavaScript to PHP, 
     * so most of the credits should go to Paul Johnston. 
     * I only re-wrote it in PHP. 
     * See http://pajhome.org.uk/site/legal.html for details.
     * Type: 	code fragment
     * Version: 	 
     * Requires: 	   
     * Added by: 	borfast (email author)
     * Entered: 	12/07/2002
     * Last modified: 	15/07/2002
     * Rating 	- (fewer than 3 votes)
     * Views 	1757
     * 
     * sha-1.php
     * A PHP implementation of the Secure Hash Algorithm, SHA-1, based on
     * the JavaScript implementation by Paul Johnston.
     * This is basically a "translation from JavaScript to PHP, so most
     * of the credits should go to Paul Johnston. I only re-wrote it in PHP.
     * See http://pajhome.org.uk/site/legal.html for details.
     */

	    /*
	     * Convert a 32-bit number to a hex string with ms-byte first
	     */
	    function hex($num)
	    {
	        $hex_chr = "0123456789abcdef";
	        $str = "";
	        for($j = 7; $j >= 0; $j--)
	        $str .= $hex_chr{(($num >> ($j * 4)) & 0x0F)};
	        return $str;
	    }
	    
	    /*
	     * Convert a string to a sequence of 16-word blocks, stored as an array.
	     * Append padding bits and the length, as described in the SHA1 standard.
	     */
	    function str2blks_SHA1($str)
	    {
	        $nblk = ((strlen($str) + 8) >> 6) + 1;
	        for($i = 0; $i < $nblk * 16; $i++) $blks[$i] = 0;
	        for($i = 0; $i < strlen($str); $i++)
	            $blks[$i >> 2] |= ord($str{$i}) << (24 - ($i % 4) * 8);
	        $blks[$i >> 2] |= 0x80 << (24 - ($i % 4) * 8);
	        $blks[$nblk * 16 - 1] = strlen($str) * 8;
	        return $blks;
	    }
	    
	    /*
	     * Bitwise rotate a 32-bit number to the left
	     */
	    
	    // zeroFill() is needed because PHP doesn't have a zero-fill
	    // right shift operator like JavaScript's >>>
	    function zeroFill($a, $b)
	    {
	        $z = hexdec(80000000);
	        if ($z & $a)
	        {
	            $a >>= 1;
	            $a &= (~$z);
	            $a |= 0x40000000;
	            $a >>= ($b-1);
	        }
	        else
	        {
	            $a >>= $b;
	        }
	        return $a;
	    }
	
	    function rol($num, $cnt)
	    {
	        return ($num << $cnt) | ($this->zeroFill($num, (32 - $cnt)));
	    }
	    
	    /*
	     * Perform the appropriate triplet combination function for the current
	     * iteration
	     */
	    function ft($t, $b, $c, $d)
	    {
	      if($t < 20) return ($b & $c) | ((~$b) & $d);
	      if($t < 40) return $b ^ $c ^ $d;
	      if($t < 60) return ($b & $c) | ($b & $d) | ($c & $d);
	      return $b ^ $c ^ $d;
	    }
	    
	    /*
	     * Determine the appropriate additive constant for the current iteration
	     */
	    function kt($t)
	    {
	      return ($t < 20) ?  1518500249 : ( ($t < 40) ?  1859775393 : ( ($t < 60) ? -1894007588 : -899497514 ) );
	    }
	    
	    /*
	     * Take a string and return the hex representation of its SHA-1.
	     */
	    function calcSHA1($str)
	    {
	        $x = $this->str2blks_SHA1($str);
	                
	        $a =  1732584193;
	        $b = -271733879;
	        $c = -1732584194;
	        $d =  271733878;
	        $e = -1009589776;
	    
	        for($i = 0; $i < count($x); $i += 16)
	        {
	            $olda = $a;
	            $oldb = $b;
	            $oldc = $c;
	            $oldd = $d;
	            $olde = $e;
	
	            for($j = 0; $j < 80; $j++)
	            {
	                if($j < 16) $w[$j] = $x[$i + $j];
	                else $w[$j] = $this->rol($w[$j-3] ^ $w[$j-8] ^ $w[$j-14] ^ $w[$j-16], 1);
	                
	                $t = $this->rol($a, 5) + $this->ft($j, $b, $c, $d) + $e + $w[$j] + $this->kt($j);
	                $e = $d;
	                $d = $c;
	                $c = $this->rol($b, 30);
	                $b = $a;
	                $a = $t;
	            }
	
	            $a += $olda;
	            $b += $oldb;
	            $c += $oldc;
	            $d += $oldd;
	            $e += $olde;
	        }
	        return $this->hex($a) . $this->hex($b) . $this->hex($c) . $this->hex($d) . $this->hex($e);
	    }
	}
?>
