<?
	//ini_set("display_errors", "1");
	require("../include/Auth.class.php");
	require("../include/Properties.class.php");
	session_start();
	
	$logins = new Properties("data/login.xml");
	if ($logins->parseFailed()) {
		;
	}
	
	$method = strtolower($_SERVER["REQUEST_METHOD"]);
	if ($method == "get") {				// show login screen
		$auth = new AuthSHA1();
		//$auth->SetMaxTries(3);
		$wildcard = $auth->GetChallengeText();
		$_SESSION["auth"] = $auth;
	}
	else if ($method == "post") {		// process login attempt
		if (! isset($_SESSION["auth"])) {					// not logged in
			header("Location: index.php");
			return;
		}
		$auth = $_SESSION["auth"];
		$password = LookupPassword($_POST["username"], $logins);
		if ($auth->Authenticate($password, $_POST["hash"])) {
			$_SESSION["logged_in"] = true;		// passed!
			header("Location: .");				// redirect to admin menu
			return;
		}
		else {									// login failed
			$_SESSION["logged_in"] = false;		// revoke previous login, if any
			header("Location: loginfailure.html");
			return;
		}
		header("Location: loginfailure.html");	// failsafe: should never fall through to here
	}
	
	function LookupPassword($user, $logins) {
		return $logins->getValue($user);
	}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html>
<head>
	<title>Login</title>
	<link href="admin.css" rel="stylesheet" type="text/css" />
	<script src="../include/formverify.js" language="JavaScript1.1" type="text/javascript"></script>
	<script src="../include/Auth.class.js" language="JavaScript1.1" type="text/javascript"></script>
</head>
<body>
<div align="center">
	<h2>Administrator Login</h2>
	<form name="login" method="POST" onsubmit="
	    this.username.required = true;
	    return verify(this);
	">
		<input type="hidden" name="wildcard" value="<? echo htmlentities($wildcard,ENT_QUOTES,"ISO-8859-1") ?>" />
		<input type="hidden" name="hash" />
		<table>
		<tr><th>Username</th><td><input type="text" name="username" value="" /></td></tr>
		<tr><th>Password</th><td><input type="password" name="password" value="" /></td></tr>
		<tr><td>&nbsp;</td></tr>
		<tr><td class="submit" colspan="2"><input type="submit" value="Log In" onclick="return LoginSHA1(document.login)" /></td></tr>
		</table>
	</form>
</div>	
</body>
</html>
