<?
	require_once("XmlSimpleBaseClass.class.php");
	
	class Installer extends XmlSimpleBaseClass {
		var $_template;
		var $_buffer;
		var $_mask = 0666;
		var $_log;
		
		function Installer($installfile) {
			$this->XmlSimpleBaseClass($installfile);
		}
		
		function _p_start_element($parser, $element, &$attributes) {
		 	parent::_p_start_element($parser, $element, &$attributes);
			$this->_buffer = "";
			switch ($element) {
				case "datatype":
					$this->_template = new TemplateFile();
					break;
			}
		}
		
		function _p_cdata($parser, $text) {
			$this->_buffer .= $text;
		}
		
				// decode entities as character data
		function _p_default($parser, $ent) {
			$this->_p_cdata($parser, html_entity_decode($ent));
		}
		
		function _p_end_element($parser, $element) {
		 	parent::_p_end_element($parser, $element);
			switch ($element) {
				case "filemask":
					if (is_int($this->_buffer)) {
						$this->_mask = intval($this->_buffer);
						$this->_log .= "File permissions will be set to: ".$this->_mask."\r\n\r\n";
					}
					break;
				case "name":
					$this->_template->SetName($this->_buffer);
					break;
				case "template":
					$this->_template->ReadTemplate($this->_buffer);
					break;
				case "destination":
					$this->_template->SetDestination($this->_buffer);
					break;
				case "datafile":
					$this->_template->WriteDatafile($this->_buffer, $this->_mask);
					break;
				case "datatype":
					$this->_log .= $this->_template->GetLoggedInfo();
			}
		}
		
		function GetLoggedInfo() {
			return $this->_log;
		}
		
		function PrintLoggedInfo() {
			print(htmlspecialchars($this->_log));
		}
	}
	
	class TemplateFile {
		var $_name = null;
		var $_contents = null;
		var $_destfolder = null;
		var $_log = "";
		
		function TemplateFile() {
			$this->LogStatus("New Template");
		}
		
		function SetName($name) {
			$this->_name = $name;
			$this->LogStatus("Template type: ".$name);
			return true;
		}
		
		function ReadTemplate($filepath) {
			$filepath = realpath($filepath);
			if (! file_exists($filepath) || ! is_readable($filepath)) {
				$this->LogStatus("Source file not found: ".$filepath."; aborting operation");
				return false;
			}
			$this->_contents = file_get_contents($filepath);
			$this->LogStatus("Source file: ".$filepath);
			return true;
		}
		
		function SetDestination($destfolder) {
			if ($this->_contents == null) {
				return false;
			}
			if (! file_exists(realpath($destfolder))) {
				$this->LogStatus("Destination not found: ".realpath($destfolder)."; aborting operation");
				return false;
			}
			$this->_destfolder = realpath($destfolder).DIRECTORY_SEPARATOR;
			$this->LogStatus("Destination: ".$this->_destfolder);
			return true;
		}
		
		function WriteDatafile($filename, $mask) {
			if ($this->_destfolder == null) {
				return false;
			}
			$filename = $this->_destfolder.$filename;
			if (file_exists($filename)) {
				$this->LogStatus("File exists: SKIPPED ".$filename);
				return false;
			}
			$f = fopen ($filename, "w");
			if ($f == null) {
				$this->LogStatus("ERROR: Could not write: ".$filename);
				return false;
			}
			fwrite($f, $this->_contents);
			fclose($f);
			chmod($filename, $mask);
			$this->LogStatus("CREATED: ".$filename);
			return true;
		}
		
		function LogStatus($msg) {
			$this->_log .= $msg."\r\n";
		}
		
		function GetLoggedInfo() {
			return $this->_log."\r\n";
		}
	}
?>