<?	// copyright (C) 2005 - Matt Newberry, matt@mattnewberry.net
	// all rights reserved, except as licensed under contract
	
	class XmlSimpleBaseClass {
		var $XML_ERROR_READABLE_INPUT_FILE_NOT_FOUND = 8001;
		var $_path = "";
		var $_tag;
		var $_parse_error = false;
		var $_error_code = 0;
		
		function XmlSimpleBaseClass($filename) {
			$this->_path = getcwd().DIRECTORY_SEPARATOR.$filename;
			if (is_readable($this->_path)) {
				$contents = file_get_contents($this->_path);
				$parser = xml_parser_create();
				xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
				xml_set_object($parser, &$this);
				xml_set_element_handler($parser, '_p_start_element', '_p_end_element');
				xml_set_character_data_handler($parser, '_p_cdata');
				xml_set_processing_instruction_handler($parser, '_p_pi');
				xml_set_default_handler($parser, '_p_default');
				$this->_parse_error = ! xml_parse($parser, $contents, true);
				$this->_error_code = xml_get_error_code($parser);
				xml_parser_free($parser);
			}
			else {
				$this->_parse_error = true;
				$this->_error_code = $this->XML_ERROR_READABLE_INPUT_FILE_NOT_FOUND;
			}
		}
		
		function _p_start_element($parser, $element, &$attributes) {
			$this->_tag = $element;
		}
		
		function _p_end_element($parser, $element) {
			$this->_tag = "";		
		}
		
		function _p_default($parser, $ent) {}
		
		function _p_pi($parser, $pi) {}
		
		/* Possible error return codes:
			0 - XML_ERROR_NONE 
				XML_ERROR_NO_MEMORY 
				XML_ERROR_SYNTAX 
				XML_ERROR_NO_ELEMENTS 
				XML_ERROR_INVALID_TOKEN 
				XML_ERROR_UNCLOSED_TOKEN 
				XML_ERROR_PARTIAL_CHAR 
				XML_ERROR_TAG_MISMATCH 
				XML_ERROR_DUPLICATE_ATTRIBUTE 
				XML_ERROR_JUNK_AFTER_DOC_ELEMENT 
				XML_ERROR_PARAM_ENTITY_REF 
				XML_ERROR_UNDEFINED_ENTITY 
				XML_ERROR_RECURSIVE_ENTITY_REF 
				XML_ERROR_ASYNC_ENTITY 
				XML_ERROR_BAD_CHAR_REF 
				XML_ERROR_BINARY_ENTITY_REF 
				XML_ERROR_ATTRIBUTE_EXTERNAL_ENTITY_REF 
				XML_ERROR_MISPLACED_XML_PI 
				XML_ERROR_UNKNOWN_ENCODING 
				XML_ERROR_INCORRECT_ENCODING 
				XML_ERROR_UNCLOSED_CDATA_SECTION 
				XML_ERROR_EXTERNAL_ENTITY_HANDLING 
				XML_ERR_PI_NOT_STARTED
		*/
		
		function getParseError() {
			return $this->_error_code;
		}
		
		function getParseMessage() {
			if ($this->_error_code == $this->XML_ERROR_READABLE_INPUT_FILE_NOT_FOUND)
				return "XML_ERROR_READABLE_INPUT_FILE_NOT_FOUND";
			return xml_error_string($this->_error_code);
		}
		
		function parseFailed() {
			return $this->_parse_error;
		}
		
		function file_write_out($text) {	// file_put_contents() not available in PHP4
			$f = fopen ($this->_path, "w");	// TODO: test is_writable()
			fwrite ($f, $text);
			fclose ($f);
			//chmod($fname, 0666);
		}
	}
	
	/*
	class XmlChildClassTemplate extends XmlSimpleBaseClass {
		
		function XmlChildClassTemplate($filename) {
			$this->XmlSimpleBaseClass($filename);
			...
		}
		
			// required method
		function _p_cdata($parser, $text) {
			switch ($this->_tag) {
				case "":
					break;
				case "":
					break;
				case "":
					break;
			}
		}
		
			// optional overrides
		// function _p_start_element($parser, $element, &$attributes) {
		// 	parent::_p_start_element($parser, $element, &$attributes);
		// 	...
		// }
		// function _p_end_element($parser, $element) {
		// 	parent::_p_end_element($parser, $element);
		// 	...
		// }
		// function _p_pi($parser, $pi) {
		//	...
		// }
		// function _p_default($parser, $ent) {
		// 	...
		// }
	}
	*/
?>