#!/usr/bin/perl
#
# CalendarScript Debugger
#
# This script will help you debug problems that might occur when trying to
# setup the CalendarScript application

# CHANGE THE LINE BELOW IF NECESSARY
# Be sure to remove the # before $BASE_DIR, and change the path between the quotes
#$BASE_DIR = "/...change.to.full.file.path.of.dir.../calendarscript/";

# DO NOT CHANGE ANYTHING BELOW HERE!

$|=1;
$QUERY_STRING = $ENV{'QUERY_STRING'};
unless ($QUERY_STRING =~ /success/) {
	print "Set-cookie: calendarscriptdebug=1;path=/\n";
	}
print "Content-type: text/html\n\n";
print "<HTML><HEAD><TITLE>CalendarScript Debugger</TITLE></HEAD>\n";
print "<BODY>\n";
print "<B><U>CalendarScript Debugger</U></B><BR><BR>\n";

sub exitNow { 
	print "<B>Once this problem is fixed, please re-run this debugger to check for any further errors!</B>";
	print "</BODY></HTML>\n";
	exit(0);
	}

# First make sure this is Perl 5
# ------------------------------
if ($]<5) {
	print <<"END";
This application requires Perl5, and it appears that you are running version $] . Most likely, 
you will need to change the first line in calendar.pl and calendar_admin.pl (which reads #!/usr/bin/perl)
to point to another path to find Perl5. Your web host will be able to assist you with this.
END
	&exitNow();
	}

# Check to see if the Path is available
# -------------------------------------
if ($BASE_DIR ne "") { $BASE_DIR =~ s|([^/])$|$1/|; }
else {
	my ($path) =  $ENV{'PATH_TRANSLATED'} || $ENV{'SCRIPT_FILENAME'};
	unless ($path) {
		$path = $0;
		$path =~ s|\\|/|g;
		$path =~ s|^[^/]*||;
		$path =~ s|[^/]*$||;
		$path .= "calendarscript/";
		print <<"END";
Your server doesn't supply CalendarScript with enough information for it to run correctly.
<BR><BR>
The program uses either the PATH_TRANSLATED or the SCRIPT_FILENAME environment variables to find out the local filesystem path of the
script itself, so it can then find its supporting files. Most web servers provide this information to CGI scripts, but yours does not.
<BR><BR>
You will need to edit the two script files - calendar.pl (or .cgi) and calendar_admin.pl (or .cgi) - and manually enter the 
filesystem path where the script is located.
<BR><BR>
You will also need to make the same change to this debug.pl (or .cgi) script in order to continue using it to debug any possible problems.
<BR><BR>
Information on how to do this can be found in the <A HREF="http://www.calendarscript.com/documentation/4.html">CalendarScript Documentation</A> 
under the problem which starts "PROBLEM: Your browser displays the message..."
<BR><BR>
If you do not know what path to use for this, the following is a suggestion. This is the best guess that this program can make given 
based on the information it has. It is not guaranteed to be correct on all systems, but might help:
<BR><BR>
<tt>Suggested Path = <span style="background-color:yellow;">$path</span></tt>
<BR><BR>
For more information, see the documentation or visit the <A HREF="http://www.CalendarScript.com/support/forum/Ultimate.cgi">Support Forum</A>
<BR><BR>
END
		&exitNow();
		}
	$path =~ s|[^/\\]*$||;
	$path =~ s|([^/])$|$1/|;
	$BASE_DIR = $path . "calendarscript/";
	}

# Check to see if this is a funky Novell setup, perhaps
# -----------------------------------------------------
$CGI_URL = $ENV{'SCRIPT_NAME'} || $ENV{'REQUEST_URI'};
if ($CGI_URL =~ /perl$/) {
	print <<"END";
The web server you are running is not supplying the correct information to this Perl script in order to proceed. This often happens on 
Novell servers, for some reason, because of the way Perl CGI scripts are executed. Please submit this text to the <A HREF="http://www.CalendarScript.com/support/forum/Ultimate.cgi">Support Forum</A> 
so that the problems can be better analyzed and perhaps fixed in a future version.
<BR>
ENV{SCRIPT_NAME} = $ENV{SCRIPT_NAME}<BR>
ENV{REQUEST_URI} = $ENV{REQUEST_URI}<BR>
END
	&exitNow();
	}

# Are we running under mod_perl?
# ------------------------------
if ($ENV{"MOD_PERL"}) {
	print <<"END";
It appears that you are running mod_perl on your server, and this script is running under it. CalendarScript does not support 
running under mod_perl. It must either be disabled or the script must be placed in a directory 
which is not under mod_perl control.
END
	&exitNow();
	}

# Check to make sure that files exist and have the correct permissions
# --------------------------------------------------------------------
sub isAsciiFile {
	my ($filename) = shift;
	open(IN,$filename);
	my ($line) = <IN>;
	chomp($line);
	$line .= <IN>;
	chomp($line);
	close(IN);
	
	return 0 if ($line =~ /[\015\012]/);
	return 1;
	}
push(@filecheck,"rw calendars.txt");
push(@filecheck,"rw config.txt");
push(@filecheck,"rw users.txt");
push(@filecheck,"rw permissions.txt");
push(@filecheck,"rw users.lock");
push(@filecheck,"rw calendars.id");
push(@filecheck,"rw users.id");
push(@filecheck,"rw users.properties");
push(@filecheck,"rw permissions.lock");
push(@filecheck,"rw permissions.id");
push(@filecheck,"rw permissions.properties");
push(@filecheck,"rw config.txt.lock");
push(@filecheck,"r ssi.txt");
push(@filecheck,"rw calendars.properties");
push(@filecheck,"rw calendars.lock");
push(@filecheck,"rw permissions_list.txt");
push(@filecheck,"rw command_list.txt");
push(@filecheck,"dr plugins");
push(@filecheck,"drw cache");
push(@filecheck,"drw session");
push(@filecheck,"dr lib");
push(@filecheck,"drw calendars");
push(@filecheck,"dr templates");
push(@filecheck,"drw calendars/default");
push(@filecheck,"drw calendars/_template");
push(@filecheck,"rw calendars/default/events.txt");
push(@filecheck,"rw calendars/default/schedule.txt");
push(@filecheck,"rw calendars/default/config.txt");
push(@filecheck,"rw calendars/default/events.lock");
push(@filecheck,"rw calendars/default/events.id");
push(@filecheck,"rw calendars/default/schedule.properties");
push(@filecheck,"rw calendars/default/schedule.lock");
push(@filecheck,"rw calendars/default/schedule.id");
push(@filecheck,"rw calendars/default/config.txt.lock");
push(@filecheck,"rw calendars/default/events.properties");
push(@filecheck,"rw calendars/_template/config.txt");
push(@filecheck,"rw calendars/_template/config.txt.lock");
push(@filecheck,"rw calendars/_template/events.id");
push(@filecheck,"rw calendars/_template/events.lock");
push(@filecheck,"rw calendars/_template/events.properties");
push(@filecheck,"rw calendars/_template/events.txt");
push(@filecheck,"rw calendars/_template/schedule.id");
push(@filecheck,"rw calendars/_template/schedule.lock");
push(@filecheck,"rw calendars/_template/schedule.properties");
push(@filecheck,"rw calendars/_template/schedule.txt");
push(@filecheck,"r lib/TimeLocal.inc");
push(@filecheck,"r lib/calendars.inc");
push(@filecheck,"r lib/CGISession.inc");
push(@filecheck,"r lib/User.pm");
push(@filecheck,"r lib/Date.inc");
push(@filecheck,"r lib/HTML.pm");
push(@filecheck,"r lib/flock.inc");
push(@filecheck,"r lib/asp.inc");
push(@filecheck,"r lib/DBFile.pm");
push(@filecheck,"r lib/DBFileUtil.inc");
push(@filecheck,"r lib/Event.inc");
push(@filecheck,"r lib/SimpleDateFormat.pm");
push(@filecheck,"r lib/ConfigFile.pm");
push(@filecheck,"rw plugins/plugins.txt");
push(@filecheck,"rw plugins/command_list.txt");
push(@filecheck,"rw plugins/permissions_list.txt");
push(@filecheck,"rw plugins/plugin_files.txt");
push(@filecheck,"dr templates/calendars");
push(@filecheck,"dr templates/admin");
push(@filecheck,"dr templates/admin/English");
push(@filecheck,"r templates/admin/English/validations.js");
push(@filecheck,"r templates/admin/English/_footer.html");
push(@filecheck,"r templates/admin/English/_header.html");
push(@filecheck,"r templates/admin/English/add_edit_event.html");
push(@filecheck,"r templates/admin/English/add_edit_field.html");
push(@filecheck,"r templates/admin/English/add_edit_user.html");
push(@filecheck,"r templates/admin/English/feedback.html");
push(@filecheck,"r templates/admin/English/approve.html");
push(@filecheck,"r templates/admin/English/calendar_settings.html");
push(@filecheck,"r templates/admin/English/setup1.html");
push(@filecheck,"r templates/admin/English/change_password.html");
push(@filecheck,"r templates/admin/English/setup2.html");
push(@filecheck,"r templates/admin/English/setup_complete.html");
push(@filecheck,"r templates/admin/English/customize_event_fields.html");
push(@filecheck,"r templates/admin/English/customize_user_fields.html");
push(@filecheck,"r templates/admin/English/dates.js");
push(@filecheck,"r templates/admin/English/edit_delete_events.html");
push(@filecheck,"r templates/admin/English/edit_delete_users.html");
push(@filecheck,"r templates/admin/English/error.html");
push(@filecheck,"r templates/admin/English/login.html");
push(@filecheck,"r templates/admin/English/main.html");
push(@filecheck,"r templates/admin/English/permissions.html");
push(@filecheck,"r templates/admin/English/permissions_error.html");
push(@filecheck,"r templates/admin/English/PopupWindow.js");
push(@filecheck,"r templates/admin/English/manage_calendars.html");
push(@filecheck,"r templates/admin/English/select_calendar.html");
push(@filecheck,"r templates/admin/English/selectbox.js");
push(@filecheck,"r templates/admin/English/styles.css");
push(@filecheck,"r templates/admin/English/tabnext.js");
push(@filecheck,"r templates/admin/English/template.html");
push(@filecheck,"r templates/admin/English/util.js");
push(@filecheck,"r templates/admin/English/_command_list.html");
push(@filecheck,"r templates/admin/English/admin_interface.html");
push(@filecheck,"r templates/admin/English/template_preferences.html");
push(@filecheck,"r templates/admin/English/schedule_event_recurring.html");
push(@filecheck,"r templates/admin/English/AnchorPosition.js");
push(@filecheck,"r templates/admin/English/CalendarPopup.js");
push(@filecheck,"r templates/admin/English/GetDate.js");
push(@filecheck,"r templates/admin/English/ColorPicker.js");
push(@filecheck,"r templates/admin/English/TimeValidations.js");
push(@filecheck,"r templates/admin/English/messages.txt");
push(@filecheck,"r templates/admin/English/add_edit_calendar.html");
push(@filecheck,"r templates/admin/English/setup3.html");
push(@filecheck,"r templates/admin/English/schedule_event_non_recur.html");
push(@filecheck,"r templates/admin/English/import_events.html");
push(@filecheck,"r templates/admin/English/plugins.html");
push(@filecheck,"dr templates/calendars/simple");
push(@filecheck,"dr templates/calendars/oldstyle");
push(@filecheck,"dr templates/calendars/default");
push(@filecheck,"r templates/calendars/default/login.html");
push(@filecheck,"r templates/calendars/default/error.html");
push(@filecheck,"r templates/calendars/default/default.html");
push(@filecheck,"r templates/calendars/default/ssi.html");
push(@filecheck,"r templates/calendars/default/preferences.pl");
push(@filecheck,"r templates/calendars/default/preferences.txt");
push(@filecheck,"r templates/calendars/oldstyle/login.html");
push(@filecheck,"r templates/calendars/oldstyle/error.html");
push(@filecheck,"r templates/calendars/oldstyle/_view.html");
push(@filecheck,"r templates/calendars/oldstyle/day.html");
push(@filecheck,"r templates/calendars/oldstyle/event_detail.html");
push(@filecheck,"r templates/calendars/oldstyle/search.html");
push(@filecheck,"r templates/calendars/oldstyle/default.html");
push(@filecheck,"r templates/calendars/oldstyle/styles_scripts.html");
push(@filecheck,"r templates/calendars/oldstyle/ssi.html");
push(@filecheck,"r templates/calendars/simple/default.html");
push(@filecheck,"r templates/calendars/simple/error.html");
push(@filecheck,"r templates/calendars/simple/login.html");
push(@filecheck,"r templates/calendars/simple/ssi.html");

foreach $line (@filecheck) {
	my ($fileproblem) = {};
	($perm,$file) = split(/\s+/,$line);
	$file = $BASE_DIR . $file;
	if ($perm =~ /d/) {
		unless (-d $file) {
			$fileproblem->{filename} = $file;
			$fileproblem->{notadir} = 1;
			}
		if ($perm =~ /r/ && -d $file && !-r $file) {
			$fileproblem->{filename} = $file;
			$fileproblem->{nodirread} = 1;
			}
		if ($perm =~ /w/ && -d $file && !-w $file) {
			$fileproblem->{filename} = $file;
			$fileproblem->{nodirwrite} = 1;
			}
		
		}
	else {
		unless (-e $file) {
			$fileproblem->{filename} = $file;
			$fileproblem->{doesntexist} = 1;
			}
		if ($perm =~ /r/ && -e $file && !-r $file) {
			$fileproblem->{filename} = $file;
			$fileproblem->{noread} = 1;
			}
		if ($perm =~ /w/ && -e $file && !-w $file) {
			$fileproblem->{filename} = $file;
			$fileproblem->{nowrite} = 1;
			}
		if (-e $file && !&isAsciiFile($file)) {
			$fileproblem->{filename} = $file;
			$fileproblem->{notascii} = 1;
			}
		}
	if ($fileproblem->{filename} ne "") {
		push(@fileproblems,$fileproblem);
		}
	}
if ($#fileproblems >= 0) {
	print <<"END";
There were problems detected with the files or directories needed by CalendarScript. These problems may be caused by one of the following:
<UL>
	<LI>"The file does not exist" problems are usually caused by the \$BASE_DIR path being incorrect.
	<LI>"No READ access" and "No WRITE access" problems are usually caused by forgetting to CHMOD the files or directories after transfer, or not giving the correct permissions in Windows.
	<LI>"The file was not transferred in ASCII mode" problems are caused by not explicitly transferring files in ASCII mode in your FTP program. Some FTP programs make it appear like you're transferring in ASCII mode, when in fact you're in "Auto" mode or something similar, and this can cause problems.
</UL>
The files with problems are listed below.
<BR><BR>
<TABLE BORDER="1">
<TR><TH>Problem</TH><TH>File/Dir</TH></TR>
END
	foreach $fileproblem (@fileproblems) {
		print "<TR><TD VALIGN=\"top\" ALIGN=\"left\">";
		if ($fileproblem->{notadir}) {
			print "&#149;The directory does not exist<BR>";
			}
		if ($fileproblem->{nodirread}) {
			print "&#149;No READ access on directory<BR>";
			}
		if ($fileproblem->{nodirwrite}) {
			print "&#149;No WRITE access on directory<BR>";
			}
		if ($fileproblem->{doesntexist}) {
			print "&#149;The file does not exist<BR>";
			}
		if ($fileproblem->{noread}) {
			print "&#149;No READ access<BR>";
			}
		if ($fileproblem->{nowrite}) {
			print "&#149;No WRITE access<BR>";
			}
		if ($fileproblem->{notascii}) {
			print "&#149;The file was not transferred in ASCII mode<BR>";
			}
		print "</TD><TD VALIGN='top' ALIGN='left'>$fileproblem->{filename}</TD></TR>\n";
		}
	print "</TABLE>";
	&exitNow();
	}

# Check to make sure that the Session ID generation works correctly
# -----------------------------------------------------------------
$id = abs(($$%1000) * time);
unless ($id =~ /^\d{3,}$/) {
print <<"END";
There is a problem with generation a unique session ID for cookies.
<BR><BR>
The unique ID that was generated is: <tt>$id</tt>
<BR><BR>
Please report this using the <A HREF="http://www.CalendarScript.com/support/forum/Ultimate.cgi">Support Forum</A> so that this
problem can be fixed and systems with your configuration may be supported.
END
	&exitNow();
	}

# Check to make sure that libraries can be included
# -------------------------------------------------
unshift(@INC,$BASE_DIR."lib");
sub includefile { 
	my $file = shift;
	eval("require '${file}';");
	$error = $@;
	if ($error) {
		push(@includeerrors, {'filename'=>$file, 'error'=>$error} );
		}
	}
&includefile('TimeLocal.inc');
&includefile("calendars.inc");
&includefile("CGISession.inc");
&includefile("User.pm");
&includefile("Date.inc");
&includefile("HTML.pm");
&includefile("ConfigFile.pm");
&includefile("flock.inc");
&includefile("asp.inc");
&includefile("DBFile.pm");
&includefile("DBFileUtil.inc");
&includefile("Event.inc");
&includefile("SimpleDateFormat.pm");
if ($#includeerrors >= 0) {
	print <<"END";
There was a problem using library modules. These are found in the calendarscript/lib directory. For some reason Perl cannot 
find these files in order to include them into the application. Please report this error to the 
<A HREF="http://www.CalendarScript.com/support/forum/Ultimate.cgi">Support Forum</A> so that it can be resolved.
<BR><BR>
The following is a list of the files which caused problems during import:
<TABLE BORDER="1">
<TR><TH>File</TH><TH>Error</TH></TR>
END
	foreach $error (@includeerrors) {
		print "<TR><TD VALIGN=top>$error->{filename}</TD><TD>$error->{error}</TD></TR>\n";
		}
	print "</TABLE>";
	&exitNow();
	}

# Make sure that the File::Copy module is available
# -------------------------------------------------
#eval("use File::Copy;");
#$error = $@;
#if ($error) {
#	print <<"END";
#There was a problem including the standard Perl module File::Copy. This module is included with 
#Perl in standard installs of at least version 5.002. If you are using this old of a version of Perl,
#consider upgrading. Otherwise, install the File::Copy module separately or ask your web host to do so.
#END
#	&exitNow();
#	}


# Check for permissions problems when using temp files
# ----------------------------------------------------
$session_dir = $BASE_DIR . "session/";
$temp_file = $session_dir . "debug.txt";
#$junk_file = $session_dir . "junk.txt";
unless (open(TMP,">$temp_file")) {
	print "There was a problem creating a temp file in the 'session' directory. Make sure that the directory has correct permissions!.<BR>The error was: $!<BR>";
	&exitNow();
	}
print TMP "Success\n";
close(TMP);
#unless (-e $junk_file) {
#	print "The file 'junk.txt' does not exist in the 'session' directory. This file is required and needs to be CHMOD 777 in order to test file copying functionality.";
#	&exitNow();
#	}
#eval("&File::Copy::move(\$temp_file,\$junk_file);");
#if ($@) {
#	$error = $@;
#	print <<"END";
#There was a problem copying a temp file over to an original file. This might be caused by 
#your file system or by a unique operating system installation. Please provide details on the
#<A HREF="http://www.CalendarScript.com/support/forum/Ultimate.cgi">CalendarScript Support Forum</A> 
#in order to help us fix it!<BR>
#The error reported was: $error
#END
#	&exitNow();
#	}
#unless (-w $junk_file) {
#	print <<"END";
#There was a problem copying a temp file over to an original file - the original file's permissions 
#were changed during the operation, which would cause the CalendarScript application to
#fail. This might be caused by 
#your file system or by a unique operating system installation. Please provide details on the
#<A HREF="http://www.CalendarScript.com/support/forum/Ultimate.cgi">CalendarScript Support Forum</A> 
#in order to help us fix it!
#END
#	&exitNow();
#	}
	

# Check to make sure javascript and cookies are enabled by submitting back to myself..
# ------------------------------------------------------------------------------------
if ($QUERY_STRING eq "") {
	print <<"END";
	<form method="GET"><input type="hidden" name="test" value="success"></form>
	<B>Testing for Javascript and Cookies...</B>
	<BR><BR>
	If you see this message for more than a few seconds, then Javascript is not enabled in your browser.
	<BR><BR>
	Javascript is required to run the calendar_admin application. Please enable it and run the debug application again!
	<SCRIPT LANGUAGE="JavaScript">
	setTimeout("document.forms[0].submit()",2000);
	</SCRIPT>
END
	}
else {
	# This is after the form has been submitted to ourself
	# Test to see if we got the cookie
	if ($ENV{'HTTP_COOKIE'} !~ /calendarscriptdebug/) {
		print "Cookies do not appear to be enabled in your browser. Cookies are required by the calendar admin application. Please enable them and run the debug application again!";
		}
	else {
		# EVERYTHING LOOKS GOOD!
		print <<"END";
		<B>Success!</B><BR>
		<BR>
		No problems were found with your installation.
		<BR>
		You should be able to run calendar and calendar_admin successfully!
END
		}
	}
print "</BODY></HTML>\n";
exit(0);
