function LTrim(str) {
	for (var i=0; str.charAt(i)==" "; i++);
	return str.substring(i,str.length);
	}
function RTrim(str) {
	for (var i=str.length-1; str.charAt(i)==" "; i--);
	return str.substring(0,i+1);
	}
function Trim(str) {
	return LTrim(RTrim(str));
	}
function isNull(val) {
	if (val == null) { return true; }
	return false;
	}
function isBlank(val) {
	if (val == null) { return true; }
	for (var i=0; i < val.length; i++) {
		if ((val.charAt(i) != ' ') && (val.charAt(i) != "\t") && (val.charAt(i) != "\n")) { return false; }
		}
	return true;
	}
function isInteger(val) {
	for (var i=0; i < val.length; i++) {
		if (!isDigit(val.charAt(i))) { return false; }
		}
	return true;
	}
function isNumeric(val) {
	return (parseFloat(val,10)==val);
	}
function isDigit(num) {
	var string="1234567890";
	if (string.indexOf(num) != -1) {
		return true;
		}
	return false;
	}
function setNullIfBlank(obj) {
	if (isBlank(obj.value)) {
		obj.value = "";
		}
	}
function disallowBlank(obj) {
	var msg;
	var dofocus;
	if (arguments.length>1) { msg = arguments[1]; }
	if (arguments.length>2) { dofocus = arguments[2]; } else { dofocus=false; }
	if (isBlank(getInputValue(obj))) {
		if (!isBlank(msg)) {
			alert(msg);
			}
		if (dofocus) {
			obj.focus();
			}
		return true;
		}
	return false;
	}
function disallowModify(obj) {
	var msg;
	var dofocus;
	if (arguments.length>1) { msg = arguments[1]; }
	if (arguments.length>2) { dofocus = arguments[2]; } else { dofocus=false; }
	if (isChanged(obj)) {
		if (!isBlank(msg)) {
			alert(msg);
			}
		if (dofocus) {
//			obj.select();
			obj.focus();
			}
		setInputValue(obj,getInputDefaultValue(obj));
		return true;
		}
	return false;
	}
function isChanged(obj) {
	if ((typeof obj.type != "string") && (obj.length > 0) && (obj[0] != null) && (obj[0].type=="radio")) {
		for (var i=0; i<obj.length; i++) {
			if (obj[i].checked != obj[i].defaultChecked) { return true; }
			}
		return false;
		}
	if ((obj.type=="text") || (obj.type=="hidden") || (obj.type=="textarea"))
		{ return (obj.value != obj.defaultValue); }
	if (obj.type=="checkbox") {
		return (obj.checked != obj.defaultChecked);
		}
	if (obj.type=="select-one") { 
		if (obj.options.length > 0) {
			var x=0;
			for (var i=0; i<obj.options.length; i++) {
				if (obj.options[i].defaultSelected) { x++; }
				}
			if (x==0 && obj.selectedIndex==0) { return false; }
			for (var i=0; i<obj.options.length; i++) {
				if (obj.options[i].selected != obj.options[i].defaultSelected) {
					return true;
					}
				}
			}
		return false;
		}
	if (obj.type=="select-multiple") {
		if (obj.options.length > 0) {
			for (var i=0; i<obj.options.length; i++) {
				if (obj.options[i].selected != obj.options[i].defaultSelected) {
					return true;
					}
				}
			}
		return false;
		}
	// return false for all other input types (button, image, etc)
	return false;
	}
function getInputValue(obj) {
	if ((typeof obj.type != "string") && (obj.length > 0) && (obj[0] != null) && (obj[0].type=="radio")) {
		for (var i=0; i<obj.length; i++) {
			if (obj[i].checked == true) { return obj[i].value; }
			}
		return "";
		}
	if (obj.type=="text") 
		{ return obj.value; }
	if (obj.type=="hidden") 
		{ return obj.value; }
	if (obj.type=="textarea") 
		{ return obj.value; }
	if (obj.type=="checkbox") {
		if (obj.checked == true) {
			return obj.value;
			}
		return "";
		}
	if (obj.type=="select-one") { 
		if (obj.options.length > 0) {
			if (obj.selectedIndex >= 0) {
				return obj.options[obj.selectedIndex].value; 
				}
			return "";
			}
		else {
			return "";
			}
		}
	if (obj.type=="select-multiple") { 
		var val = "";
		for (var i=0; i<obj.options.length; i++) {
			if (obj.options[i].selected) {
				val = val + "" + obj.options[i].value + ",";
				}
			}
		if (val.length > 0) {
			val = val.substring(0,val.length-1); // remove trailing comma
			}
		return val;
		}
	return "";
	}
function getInputDefaultValue(obj) {
	if ((typeof obj.type != "string") && (obj.length > 0) && (obj[0] != null) && (obj[0].type=="radio")) {
		for (var i=0; i<obj.length; i++) {
			if (obj[i].defaultChecked == true) { return obj[i].value; }
			}
		return "";
		}
	if (obj.type=="text") 
		{ return obj.defaultValue; }
	if (obj.type=="hidden") 
		{ return obj.defaultValue; }
	if (obj.type=="textarea") 
		{ return obj.defaultValue; }
	if (obj.type=="checkbox") {
		if (obj.defaultChecked == true) {
			return obj.value;
			}
		return "";
		}
	if (obj.type=="select-one") {
		if (obj.options.length > 0) {
			for (var i=0; i<obj.options.length; i++) {
				if (obj.options[i].defaultSelected) {
					return obj.options[i].value;
					}
				}
			}
		return "";
		}
	if (obj.type=="select-multiple") { 
		var val = "";
		for (var i=0; i<obj.options.length; i++) {
			if (obj.options[i].defaultSelected) {
				val = val + "" + obj.options[i].value + ",";
				}
			}
		if (val.length > 0) {
			val = val.substring(0,val.length-1); // remove trailing comma
			}
		return val;
		}
	return "";
	}
function setInputValue(obj,val) {
	if ((typeof obj.type != "string") && (obj.length > 0) && (obj[0] != null) && (obj[0].type=="radio")) {
		for (var i=0; i<obj.length; i++) {
			if (obj[i].value == val) { 
				obj[i].checked = true;
				}
			else {
				obj[i].checked = false;
				}
			}
		}
	if (obj.type=="text") 
		{ obj.value = val; }
	if (obj.type=="hidden") 
		{ obj.value = val; }
	if (obj.type=="textarea") 
		{ obj.value = val; }
	if (obj.type=="checkbox") {
		if (obj.value == val) { obj.checked = true; }
		else { obj.checked = false; }
		}
	if ((obj.type=="select-one") || (obj.type=="select-multiple")) {
		for (var i=0; i<obj.options.length; i++) {
			if (obj.options[i].value == val) {
				obj.options[i].selected = true;
				}
			else {
				obj.options[i].selected = false;
				}
			}
		}
	}
function copyValue(source, target) {
	setInputValue(target, getInputValue(source));
	}
