// getAnchorPosition(anchorname)
//   This function returns an object having .x and .y properties which are the coordinates
//   of the named anchor, relative to the page.
function getAnchorPosition(anchorname) {
	// This function will return an Object with x and y properties
	var useWindow = false;
	var coordinates = new Object();
	var x=0;
	var y=0;
	// Browser capability sniffing
	var use_gebi = false;
	var use_css = false;
	var use_layers = false;
	if (document.getElementById) { use_gebi = true; }
	else if (document.all) { use_css = true; }
	else if (document.layers) { use_layers = true; }
	// Logic to find position
 	if (use_gebi && document.all) {
		x = AnchorPosition_getPageOffsetLeft(document.all[anchorname]);
		y = AnchorPosition_getPageOffsetTop(document.all[anchorname]);
		}
	else if (use_gebi) {
		var o = document.getElementById(anchorname);
		x = o.offsetLeft;
		y = o.offsetTop;
		}
 	else if (use_css) {
		x = AnchorPosition_getPageOffsetLeft(document.all[anchorname]);
		y = AnchorPosition_getPageOffsetTop(document.all[anchorname]);
		}
	else if (use_layers) {
		var found=0;
		for (var i=0; i<document.anchors.length; i++) {
			if (document.anchors[i].name == anchorname) {
				found=1;
				break;
				}
			}
		if (found == 0) {
			coordinates.x=0; coordinates.y=0; return coordinates;
			}
		x = document.anchors[i].x;
		y = document.anchors[i].y;
		}
	else {
		coordinates.x=0; coordinates.y=0; return coordinates;
		}
	coordinates.x = x;
	coordinates.y = y;
	return coordinates;
	}

// getAnchorWindowPosition(anchorname)
//   This function returns an object having .x and .y properties which are the coordinates
//   of the named anchor, relative to the window
function getAnchorWindowPosition(anchorname) {
	var coordinates = getAnchorPosition(anchorname);
	var x=0;
	var y=0;
	if (document.getElementById) {
		if (isNaN(window.screenX)) {
			x = coordinates.x - document.body.scrollLeft + window.screenLeft;
			y = coordinates.y - document.body.scrollTop + window.screenTop;
			}
		else {
			x = coordinates.x + window.screenX + (window.outerWidth-window.innerWidth) - window.pageXOffset;
			y = coordinates.y + window.screenY + (window.outerHeight-24-window.innerHeight) - window.pageYOffset;
			}
		}
	else if (document.all) {
		x = coordinates.x - document.body.scrollLeft + window.screenLeft;
		y = coordinates.y - document.body.scrollTop + window.screenTop;
		}
	else if (document.layers) {
		x = coordinates.x + window.screenX + (window.outerWidth-window.innerWidth) - window.pageXOffset;
		y = coordinates.y + window.screenY + (window.outerHeight-24-window.innerHeight) - window.pageYOffset;
		}
	coordinates.x = x;
	coordinates.y = y;
	return coordinates;
	}

// Functions for IE to get position of an object
function AnchorPosition_getPageOffsetLeft (el) {
	var ol = el.offsetLeft;
	while ((el = el.offsetParent) != null) { 
		ol += el.offsetLeft; 
		}
	return ol;
	}
function AnchorPosition_getWindowOffsetLeft (el) {
	var scrollamount = document.body.scrollLeft;
	return AnchorPosition_getPageOffsetLeft(el)-scrollamount;
	}	
function AnchorPosition_getPageOffsetTop (el) {
	var ot = el.offsetTop;
	while((el = el.offsetParent) != null) { 
		ot += el.offsetTop; 
		}
	return ot;
	}
function AnchorPosition_getWindowOffsetTop (el) {
	var scrollamount = document.body.scrollTop;
	return AnchorPosition_getPageOffsetTop(el)-scrollamount;
	}
