# ASP-Template Routines

#####################################################################
# ASPEval
#   Parse an "ASP" template and eval() the whole thing
#####################################################################
sub ASPEval {
	my ($template,$template_dir) = @_;
	return $junk = eval(&ASPParse($template,$template_dir));
	}

#####################################################################
# ASPError
#   ASP Template Parse Error Output
#####################################################################
sub ASPError {
	$tmp_template_before_parsing =~ s|<|&lt;|gs; $template1 =~ s|>|&gt;|gs;
	print "<B>ERROR PROCESSING TEMPLATE</B><BR>";
	print "There was an error in your template file. Below is the template file and also the perl code generated from it to help you with debugging.<br><br>\n";
	$error = $@;
	$error =~ s|(line\s*\d+)|<a href="#error">$1</a>|;
	print "$error<br>\n";
	print "<HR>";
	print "<PRE>$tmp_template_before_parsing</PRE>";
	print "<HR>";
	($line) = ($@ =~ /line\s*(\d+)/);
	$tmp_template_after_parsing =~ s|<|&lt;|gs; $tmp_template_after_parsing =~ s|>|&gt;|gs;
	#$tmp_template_after_parsing =~ s|\\\\(.)|$1|gs;
	$tmp_template_after_parsing =~ s|\n|-LINEBREAK-|gs;
	@template = split('-LINEBREAK-',$tmp_template_after_parsing);
	$template[$line-1] = "<A NAME='error'></A><DIV STYLE='background-color:yellow'>\n" . $template[$line-1] . "\n\n</DIV>";
	$tmp_template_after_parsing = join("\n",@template);
	print "<PRE>$tmp_template_after_parsing</PRE>";
	}

#####################################################################
# ASPCustomTag
#   Add a custom tag to the ASP processor
#####################################################################
sub ASPCustomTag {
	my ($tag) = shift;
	my ($replace) = shift;
	$ASPTags{$tag} = $replace;
	}

#####################################################################
# ASPParse
#   Parse an "ASP" template and turn it into pure Perl code
#####################################################################
sub ASPParse {
	my ($template) = shift;
	my ($template_dir) = shift;
	my ($start, $start_pad, $start_pad_tmp, $tmp, $end_pad, $end_pad_tmp, $end);
	my ($tag);

	# Include files
	$template =~ s@\<\!--\#include\s*file="([^"]+)"\s*--\>@
				$file = $template_dir.$1;
				$openerror = 0;
				$result = "";
				open(INCLUDE,"$file") || ($openerror=1);
				if ($openerror == 1) {
					$result = "[Include file ($file) could not be found]";
					}
				else {
					while (<INCLUDE>) {
						$result .= $_;
						}
					close(INCLUDE);
					}
				$result;
			 @gex;
			 
	$tmp_template_before_parsing = $template;

	# Take out all comments
	#$template =~ s/<!--.*?-->//mgs;
	$template =~ s/<%--.*?--%>//mgs;

	# Replace special commands
	foreach $tag (keys %ASPTags) { 
		if ($ASPTags{$tag} =~ /\$1/) {
			$template =~ s|<%$tag%>|my($match)=$1;my($out)=$ASPTags{$tag};$out=~s@\$1@$match@gs;"<%$out%>";|gesi;
			}
		else {
			$template =~ s|<%$tag%>|<%$ASPTags{$tag}%>|gsi;
			}
		}
	$template =~ s@(^|\%\>)([\s\n]*)(.*?)([\s\n]*)(\<\%|$)@
                 ($start,$start_pad,$tmp,$end_pad,$end) = ($1,$2,$3,$4,$5);
				     ($start_pad_tmp,$end_pad_tmp) = ($start_pad,$end_pad);
                 $end_pad_tmp =~ s!\n!\\n!gs;
				     $start_pad_tmp =~ s!\n!\\n!gs;
				     $tmp =~ s!\\!\\\\!gs;
				     $tmp =~ s!\n!\\n!gs;
                 $tmp =~ s!"!\\"!gs;
                 $tmp =~ s!\$!\\\$!gs;
                 $tmp =~ s!\@!\\\@!gs;
                 $tmp =~ s/^(.*?)$/print \"${start_pad_tmp}${1}${end_pad_tmp}\";/mg;
                 "${start}${start_pad}${tmp}${end_pad}${end}";
                 @gsex;

	$template =~ s/<%=\s*(.+?)\s*%>/print $1;/gs;
	$template =~ s/<%\s*(.*?)\s*%>/$1/gs;
	
	# Put the code into a Template package
	$template = "package Template;\n" . $template;
	$template .= "package main;\n";
	$tmp_template_after_parsing = $template;
	return $template;
	}

#####################################################################
# ASPLoadTemplate
#   Load a template file to pass to ASPParse
#####################################################################
sub ASPLoadTemplate {
	my ($filename) = shift;
	my ($template);
	open(IN,$filename) || &FATALERROR("Couldn't open Template [$filename] : $!");
	undef $/;
	$template = <IN>;
	$/ = "\n";
	close(IN);
	return $template;
	}

1;
