#####################################################################
# Package to deal with the logged-in user
#####################################################################
package User;

# Error-handling
# --------------
sub setErrorMessage {
	my ($self,$msg) = @_;
	$self->{'_errorMessage'} = $msg;
	}
sub getErrorMessage {
	my ($self) = @_;
	return $self->{'_errorMessage'};
	}

# New User
# --------
sub new {
	my ($class,$username,$users_db,$permissions_db) = @_;
	my $self = bless { }, $class;
	$self->{'username'} = $username;
	unless ($username && $users_db && $permissions_db) {
		return $self;
		}
	$self->{'_users_db'} = new DBFile($users_db);
	$self->{'_permissions_db'} = new DBFile($permissions_db);
	my ($record) = $self->{'_users_db'}->getRecord( {'username'=>$username} );
	if ($record) {
		foreach $key (keys %$record) {
			$self->{$key} = $record->{$key};
			}
		$self->readPermissions();
		$self->{'_is_valid'} = 1;
		}
	return $self;	
	}

# Validate login/password against password file
# ---------------------------------------------
sub login {
	my ($self,$password) = @_;
	unless ($self->{'_is_valid'}) {
		$self->setErrorMessage(&main::getMessage("USER_USER_NOT_FOUND",$self->{'username'}));
		return 0;
		}
	if ($self->{'username'} eq "anonymous") {
		return 1;
		}
	if ($self->{'password'} eq "") {
		return 2;
		}
	if (crypt($password,$self->{'password'}) eq $self->{'password'}) {
		return 1;
		}
	else {
		$self->setErrorMessage(&main::getMessage("USER_INVALID_PASSWORD"));
		return 0;
		}
	}


# Change a password
# -----------------
sub changePassword {
	my ($self,$oldPassword,$newPassword) = @_;
	my ($db) = $self->{'_users_db'};
	if ($self->{'password'} eq "") {
		if ($db->updateRecords( {'username'=>$self->{'username'}} , {'password'=>crypt($newPassword,"junk")} )) {
			return 1;
			}
		$self->setErrorMessage($db->getErrorMessage());
		return 0;
		}
	else {
		if (crypt($oldPassword,$self->{'password'}) eq $self->{'password'}) {
			if ($db->updateRecords( {'username'=>$self->{'username'}} , {'password'=>crypt($newPassword,"junk")} )) {
				return 1;
				}
			$self->setErrorMessage($db->getErrorMessage());
			return 0;
			}
		else {
			$self->setErrorMessage(&main::getMessage("USER_INVALID_PASSWORD"));
			return 0;
			}
		}
	}

# Read in the permissions table
# -----------------------------
sub readPermissions {
	my($self) = @_;
	my ($records,$record);
	delete $self->{'_permissions'};
	$records = $self->{'_permissions_db'}->getRecords({});
	foreach $record (@$records) {
		$self->{'_permissions'}->{$record->{'username'}}->{$record->{'calendar'}}->{$record->{'action'}} = 1;
		}
	}

# Check if an action is permitted
# -------------------------------
sub hasPermission {
	my ($self,$calendar,$action,$user) = @_;
	my ($username) = $user || $self->{'username'};
	if ($calendar eq "") { $calendar = "_global"; }
	if ($username eq "Administrator") { return 1; }
	if ($self->{'_permissions'}->{"_all"}->{$calendar}->{$action}) { return 1; }
	if ($self->{'_permissions'}->{$username}->{"_all"}->{"_all"}) { return 1; }
	if ($self->{'_permissions'}->{$username}->{"_all"}->{$action}) { return 1; }
	if ($self->{'_permissions'}->{$username}->{$calendar}->{"_all"}) { return 1; }
	if ($self->{'_permissions'}->{$username}->{$calendar}->{$action}) { return 1; }
	return 0;
	}

# Check if a specific permission is set
# -------------------------------------
sub isPermissionSet {
	my ($self,$calendar,$action,$username) = @_;
	if ($self->{'_permissions'}->{$username}->{$calendar}->{$action}) { return 1; }
	return 0;
	}

# See if user has any admin access to a calendar
# ----------------------------------------------
sub isCalendarAdmin {
	my ($self,$calendar) = @_;
	if ($self->{'username'} eq "Administrator") { return 1; }
	if ($self->{'_permissions'}->{"_all"}->{$calendar}) { return 1; }
	if ($self->{'_permissions'}->{$self->{'username'}}->{$calendar}) { return 1; }
	if ($self->{'_permissions'}->{$self->{'username'}}->{"_all"}) { return 1; }
	return 0;
	}

package main;
1;

