package SimpleDateFormat;
# This is written to function exactly like the javascript version

sub LZ { my($x)=shift;if(length($x)==1){return "0$x";}return $x; }

sub formatDate {
	my ($time,$format) = @_;
	my ($p,$i,$c,$token,$result);
	my ($s,$m,$H,$d,$M,$y,$wd,$yd,$isdst) = gmtime($time);
	$p->{'s'} = $s;
	$p->{'m'} = $m;
	$p->{'H'} = $H;
	$p->{'d'} = $d;
	$p->{'M'} = $M+1;
	$p->{'y'} = $y+1900;
	$p->{'yyyy'} = $p->{'y'};
	($p->{'yy'})   = ($p->{'yyyy'}=~/(\d\d)$/);
	$p->{'yy'}   = &LZ($p->{'yy'});
	$p->{'MM'}   = &LZ($p->{'M'});
	$p->{'dd'}   = &LZ($p->{'d'});
	$p->{'h'}    = $p->{'H'}+1;
	$p->{'K'}    = $p->{'H'};
	$p->{'k'}    = $p->{'H'}+1;
	if ($p->{'h'} > 12) { $p->{'h'}-=12; }
	if ($p->{'h'} == 0) { $p->{'h'}=12; }
	$p->{'hh'} = &LZ($p->{'h'});
	if ($p->{'H'} < 10) { $p->{'HH'} = "0"+$p->{'K'}; }
		else { $p->{'HH'} = $p->{'H'}; }
	if ($p->{'K'} > 11) { $p->{'K'}-=12; }
	$p->{'KK'} = &LZ($p->{'K'});
	$p->{'kk'} = &LZ($p->{'k'});
	if ($p->{'H'} > 11) { $p->{'a'}="PM"; }
	else { $p->{'a'}="AM"; }
	$p->{'mm'} = &LZ($p->{'m'});
	$p->{'ss'} = &LZ($p->{'s'});
	$i=0;
	while ($i < length($format)) {
		$c = substr($format,$i,1);
		$token = "";
		while ((substr($format,$i,1) eq $c) && ($i < length($format))) {
			$token .= substr($format,$i,1);
			$i++;
			}
		if (defined $p->{$token}) {
			$result .= $p->{$token};
			}
		else {
			$result .= $token;
			}
		}
	return $result;
	}
	
sub _isInteger {
	my ($val) = shift;
	if ($val =~ /^\d+$/) {
		return 1;
		}
	return 0;
	}
sub _getInt {
	my ($str,$i,$minlength,$maxlength) = @_;
	my ($x,$token);
	for ($x=$maxlength; $x>=$minlength; $x--) {
		$token = substr($str,$i,$x);
		if (length($token) < $minlength) {
			return "";
			}
		if (&_isInteger($token)) { 
			return $token;
			}
		}
	return "";
	}
sub getDateFromFormat {
	my ($val,$format) = @_;
	my ($i,$i_val,$i_format,$c,$token,$token2,$x,$y,$month_name,$time);
	my ($ss,$mm,$hh,$date,$month,$year,$wd,$yd,$isdst) = localtime(time);
	my ($ampm) = "";
	while ($i_format < length($format)) {
		$c = substr($format,$i_format,1);
		$token = "";
		while ((substr($format,$i_format,1) eq $c) && ($i_format < length($format))) {
			$token .= substr($format,$i_format,1);
			$i_format++;
			}
		if ($token eq "yyyy" || $token eq "yy" || $token eq "y") {
			if ($token=="yyyy") { $x=4;$y=4; }
			if ($token=="yy")   { $x=2;$y=2; }
			if ($token=="y")    { $x=2;$y=4; }
			$year = &_getInt($val,$i_val,$x,$y);
			if ($year eq "") { return -1; }
			$i_val += length($year);
			if (length($year) == 2) {
				if ($year > 70) {
					$year = 1900+$year;
					}
				else {
					$year = 2000+$year;
					}
				}
			}
		elsif ($token eq "MM" || $token eq "M") {
			$x=length($token); $y=2;
			$month = &_getInt($val,$i_val,$x,$y);
			if ($month eq "") { return -4; }
			if (($month < 1) || ($month > 12)) { return -5; }
			$i_val += length($month);
			}
		elsif ($token eq "dd" || $token eq "d") {
			$x=length($token); $y=2;
			$date = &_getInt($val,$i_val,$x,$y);
			if ($date eq "") { return -6; }
			if (($date < 1) || ($date>31)) { return -7; }
			$i_val += length($date);
			}
		elsif ($token eq "hh" || $token eq "h") {
			$x=length($token); $y=2;
			$hh = &_getInt($val,$i_val,$x,$y);
			if ($hh eq "") { return -8; }
			if (($hh < 1) || ($hh > 12)) { return -9; }
			$i_val += length($hh);
			$hh--;
			}
		elsif ($token eq "HH" || $token eq "H") {
			$x=length($token); $y=2;
			$hh = &_getInt($val,$i_val,$x,$y);
			if ($hh eq "") { return -10; }
			if (($hh < 0) || ($hh > 23)) { return -11; }
			$i_val += length($hh);
			}
		elsif ($token eq "KK" || $token eq "K") {
			$x=length($token); $y=2;
			$hh = &_getInt($val,$i_val,$x,$y);
			if ($hh eq "") { return -12; }
			if (($hh < 0) || ($hh > 11)) { return -13; }
			$i_val += length($hh);
			}
		elsif ($token eq "kk" || $token eq "k") {
			$x=length($token); $y=2;
			$hh = &_getInt($val,$i_val,$x,$y);
			if ($hh eq "") { return -14; }
			if (($hh < 1) || ($hh > 24)) { return -15; }
			$i_val += length($hh);
			$h--;
			}
		elsif ($token eq "mm" || $token eq "m") {
			$x=length($token); $y=2;
			$mm = &_getInt($val,$i_val,$x,$y);
			if ($mm eq "") { return -16; }
			if (($mm < 0) || ($mm > 59)) { return -17; }
			$i_val += length($mm);
			}
		elsif ($token eq "ss" || $token eq "s") {
			$x=length($token); $y=2;
			$ss = &_getInt($val,$i_val,$x,$y);
			if ($ss eq "") { return -18; }
			if (($ss < 0) || ($ss > 59)) { return -19; }
			$i_val += length($ss);
			}
		elsif ($token eq "a") {
			if (lc(substr($val,$i_val,2)) eq "am") {
				$ampm = "AM";
				}
			elsif (lc(substr($val,$i_val,2)) eq "pm") {
				$ampm = "PM";
				}
			else {
				return -20;
				}
			$i_val+=2;
			}
		else {
			if (substr($val,$i_val,length($token)) ne $token) {
				return -21;
				}
			else {
				$i_val += length($token);
				}
			}
		}
	if ($i_val != length($val)) {
		return -22;
		}
	if ($month == 2) {
		if ( ( ($year%4 == 0)&&($year%100 != 0) ) || ($year%400 == 0) ) {
			if ($date > 29){ return false; }
			}
		else {
			if ($date > 28) { return false; }
			}
		}
	if (($month==4)||($month==6)||($month==9)||($month==11)) {
		if ($date > 30) { return false; }
		}
	if ($hh<12 && ($ampm eq "PM")) {
		$hh+=12;
		}
	elsif ($hh>11 && ($ampm eq "AM")) {
		$hh-=12;
		}
	$time = Time::Local::timegm($ss,$mm,$hh,$date,$month-1,$year);
	return $time;
	}

package main;
1;
