package HTML;

# Common HTML elements
# --------------------
sub monthNameOptions {
	my ($selected,$abbr) = @_;
	my ($monthnames) = $main::Config->get("month_names");
	my ($monthabbrs) = $main::Config->get("month_abbreviations");
	my ($i);
	my ($ol) = new HTML::optionList();
	for ($i=0; $i<12; $i++) {
		if ($abbr) {
			$ol->addOptions($i+1,$monthabbrs->[$i]);
			}
		else {
			$ol->addOptions($i+1,$monthnames->[$i]);
			}
		$ol->setSelectedIndex($selected-1);
		}
	return $ol->toString();
	}

sub monthAbbreviationOptions {
	my ($selected) = @_;
	return &HTML::monthNameOptions($selected,1);
	}

sub dateOptions {
	my ($date) = @_;
	my ($ol) = new HTML::optionList();
	my ($i);
	for ($i=1; $i<32; $i++) {
		$ol->addSimpleOptions($i);
		}
	$ol->setSelectedIndex($date-1);
	return $ol->toString();
	}

sub yearOptions {
	my ($year) = @_;
	my ($ol) = new HTML::optionList();
	my ($i);
	my ($current_year) = (localtime(time+$main::localtime_offset))[5] + 1900;
	for ($i=$current_year-$main::Config->get("year_option_range_back"); $i<=$year+$main::Config->get("year_option_range_forward"); $i++) {
		$ol->addSimpleOptions($i);
		}
	$ol->setSelectedValue($year);
	return $ol->toString();
	}

sub filter {
	my ($text) = @_;
	$text =~ s|<|&lt;|gs;
	$text =~ s|>|&gt;|gs;
	return $text;
	}

sub autoLink {
	my ($text,$target) = @_;
	if ($target ne "") {
		$target = " TARGET=\"$target\" ";
		}
	$text =~ s#(^|\s)(http://\S*)#$1<A HREF="$2" $target>$2</A>#gs;
	return $text;
	}

sub encodeHTML {
	my ($html) = @_;
	$html =~ s|&|&amp;|gs;
	$html =~ s|<|&lt;|gs;
	$html =~ s|>|&gt;|gs;
	$html =~ s|"|&quot;|gs;
	return $html;
	}

# Option List object
# ------------------
package HTML::optionList;
sub new {
	my ($class) = shift;
	my $self = bless { }, $class;
	}
sub addOption {
	my ($self,$v,$n) = @_;
	$self->addOptions($v,$n);
	}
sub addOptions {
	my ($self) = shift;
	my ($v, $n);
	while ($#_ >= 0) {
		$v = shift;
		$n = shift;
		push( @{$self->{'options'}}, {'name'=>$n,'value'=>$v} );
		}
	}
sub addSimpleOptions {
	my ($self) = shift;
	my ($v);
	while ($#_ >= 0) {
		$v = shift;
		push( @{$self->{'options'}}, {'name'=>$v,'value'=>$v} );
		}
	}
sub setSelectedIndex {
	my ($self,$i) = @_;
	$self->{'selectedIndex'}=$i;
	}
sub setSelectedValue {
	my ($self,$v) = @_;
	$self->{'selectedValue'} = $v;
	}
sub setSelectedName {
	my ($self,$v) = @_;
	$self->{'selectedName'} = $v;
	}
sub toString {
	my ($self) = @_;
	return "" unless ($self->{'options'});
	my ($nvp,$ret,$i,$sel);
	for ($i=0; $i<=$#{$self->{'options'}}; $i++) {
		$nvp = ${$self->{'options'}}[$i];
		if ($self->{'selectedValue'} eq $nvp->{'value'}) {
			$sel = " SELECTED";
			}
		elsif (($self->{'selectedIndex'} ne "") && ($self->{'selectedIndex'} == $i)) {
			$sel = " SELECTED";
			}
		elsif ($self->{'selectedName'} eq $nvp->{'name'}) {
			$sel = " SELECTED";
			}
		else {
			$sel = "";
			}
		$ret .= "<OPTION VALUE=\"$nvp->{value}\"$sel>$nvp->{name}</OPTION>";
		}
	return $ret;
	}

1;