package Event;

$RECURRING="recurring";
$WEEKLY = "weekly";
$MONTHLY = "monthly";
$YEARLY = "yearly";
$STATIC = "static";
$RELATIVE = "relative";
$MULTIPLE = "multiple";
$FIRST = "first";
$SECOND = "second";
$THIRD = "third";
$FOURTH = "fourth";
$FIFTH = "fifth";
$LAST = "last";
$ERROR_MESSAGE="";

sub setErrorMessage { $ERROR_MESSAGE=shift; }
sub getErrorMessage { return $ERROR_MESSAGE; }

sub LZ { my($x)=shift;if(length($x)==1){return "0$x";}return $x; }
sub UNLZ { my($x)=shift;if($x =~ /^0+$/){return 0;}$x=~s|^0*||;return $x; }
sub dateSuffix {
	my ($date) = @_;
	$date =~ s|1$|1st|;     return $date;
	$date =~ s|2$|2nd|;     return $date;
	$date =~ s|3$|3rd|;     return $date;
	$date =~ s|(\d)$|$1th|; return $date;
	}

# Search events
# If passed a search string, match anything in the record
# If passed a hash of properties, match each one separately
# -------------------------------------------------------------------------
sub search {
	my ($events_db,$schedule_db,$search,$properties,$starttime,$endtime) = @_;
	my ($matches, $e, $ids, $details, $event_id_index, $line, @values, $schedules, $events);
	my $check_approved=1;

	if (defined $properties->{'approved'}) { $check_approved = 0; }
	if ($search) {
		$matches = $events_db->simpleSearch($search);
		}
	else {
		foreach (keys %$properties) {
			$properties->{$_} = "/".quotemeta($properties->{$_})."/";
			}
		$matches = $events_db->getRecords($properties);
		}

	unless ($matches) { return (); }
	foreach $e (@$matches) {
		if ($properties->{'my_events'}) {
			next unless ($e->{'author_id'} eq $main::User->{'username'});
			}
		$ids->{$e->{'id'}} = 1;
		$details->{$e->{'id'}} = $e;
		}
	# To be more efficient, don't use the general DBFile 
	unless(open(DB,$schedule_db->{'_dbfile'})) {
		&setErrorMessage(&main::getMessage("EVENT_SAVE_ERROR",$db->{'_dbfile'}));
		return 0;
		}
	$event_id_index = $schedule_db->{'fieldindex'}->{'event_id'};
	while($line = <DB>) {
		next if $line=~/^#/;
		next unless ($line =~ /\S/);
		chomp;
		@values = split(/\t/,$line);
		next unless ($ids->{$values[$event_id_index]});
		next if $schedules->{$values[$event_id_index]};
		$schedules->{$values[$event_id_index]} = $schedule_db->makeRecord($line);
		}
	close(DB);
	foreach $id (keys %$ids) {
		next if ($check_approved && !$details->{$id}->{'approved'});

		# Make sure it occurs between selected search dates, if they exist
		my ($nextoccurrence) = &getNextOccurrence($schedules->{$id},$starttime,$endtime);

		if ($starttime) {
			next if (($nextoccurrence->{'start'} < $starttime) || ($nextoccurrence->{'start'} > $endtime));
			}
		$schedules->{$id}->{'nextoccurrence'} = $nextoccurrence;
		push(@$events, {'details'=>$details->{$id}, 'schedule'=>$schedules->{$id} });
		}
	return $events;
	}

# Get all events for a given month/year
# -------------------------------------
sub getEvents {
	my ($events_db,$schedule_db,$properties) = @_;
	my ($ss,$mi,$hh,$dd,$mm,$yy,$wd,$yd,$dst) = localtime(time+$main::localtime_offset);
	my ($event_ids,$events,$event_details,$s);
	my ($month,$year,$date,$datestring,$start,$end);
	
	$month = &LZ($properties->{'month'}) || &LZ($mm+1);
	$year = $properties->{'year'} || ($yy+1900);
	$date = &LZ($properties->{'date'}) || &LZ($dd);
	
	if ($properties->{'range'} eq "month") {
		$datestring = $year . $month . "01";
		($start,$end) = &Date::getTimeSpan( {'range'=>'month','startdate'=>$datestring } );
		}
	
	$schedule = &getEventsInRange($schedule_db,$start,$end);
	foreach $s (@$schedule) {
		$event_ids->{$s->{'event_id'}}=1;
		}
	$event_details = &getEventDetails($events_db,$event_ids);
	
	foreach $s (@$schedule) {
		# Skip the event unless it's approved
		next unless ($event_details->{$s->{'event_id'}}->{'approved'});
		# Skip if it's private
		next if ($event_details->{$s->{'event_id'}}->{'private'});
		# If showing only my events, skip if I'm not the author
		if ($properties->{'my_events'}) {
			next unless ($event_details->{$s->{'event_id'}}->{'author_id'} eq $main::User->{'username'});
			}
		push(@$events, { 'schedule'=>$s, 'details'=>$event_details->{$s->{'event_id'}} } );
		}
	return $events;
	}

# Retrieve all events given a list of ID's
# ----------------------------------------
sub getEventDetails {
	# To be more efficient, don't use the general DBFile searches
	my ($db,$ids) = @_;
	my ($line,@values,$id_index,@events);
	unless(open(DB,$db->{'_dbfile'})) {
		&setErrorMessage(&main::getMessage("DBFILE_FILE_OPEN_READ",$db->{'_dbfile'}));
		return 0;
		}
	$id_index = $db->{'fieldindex'}->{'id'};
	while($line = <DB>) {
		next if $line=~/^#/;
		next unless ($line =~ /\S/);
		chomp;
		@values = split(/\t/,$line);
		$id = $values[$id_index];
		if ( $ids->{$id} ) {
			my ($event) = $db->makeRecord($line);
			$events->{$id} = $event;
			}
		}
	close(DB);
	return $events;
	}

# Retrieve all event schedules falling within a start/end time
# -------------------------------------------------------------
sub getEventsInRange {
	# To be more efficient, don't use the general DBFile searches
	my ($db,$s,$e) = @_;
	my ($start_index,$end_index,$recurring_type_index,$line,@values,$occurrence,@matches);
	unless(open(DB,$db->{'_dbfile'})) {
		&setErrorMessage(&main::getMessage("DBFILE_FILE_OPEN_READ",$db->{'_dbfile'}));
		return 0;
		}
	$start_index = $db->{'fieldindex'}->{'start'};
	$end_index = $db->{'fieldindex'}->{'end'};
	$recurring_type_index = $db->{'fieldindex'}->{'recurrence_type'};
	while($line = <DB>) {
		next if $line=~/^#/;
		next unless ($line =~ /\S/);
		chomp;
		@values = split(/\t/,$line);
		if (($values[$start_index] eq "") || ($values[$end_index] eq "")) {
			my($schedule) = $db->makeRecord($line);
			# Set time span start/end to be the timeframe we're looking for
			# Get all occurrences between these times for this recurring event
			# This is not efficient! BOUND YOUR RECURRING EVENTS! :)
			$schedule->{'start'} ||= $s;
			$schedule->{'end'} ||= $e;
			my($occurrences) = &getRecurrenceTimes($schedule);
			foreach $occurrence (@$occurrences) {
				my (%tmp) = %$schedule;
				$tmp{'start'} = $occurrence->{'start'};
				$tmp{'end'} = $occurrence->{'end'};
				$tmp{'date'} = $occurrence->{'date'};
				$tmp{'year'} = $occurrence->{'year'};
				$tmp{'day'} = $occurrence->{'day'};
				push(@matches,\%tmp);
				}
			}
		elsif (($s <= $values[$end_index]) && ($e >= $values[$start_index])) {
			push(@matches,$db->makeRecord($line));
			}
		}
	close(DB);

	return \@matches;
	}

# Schedule an event and add it to the database
# --------------------------------------------
sub scheduleEvent {
	my ($db,$schedule,$event_id) = @_;
	my ($month,$date,$wday,$which,$start_time,$end_time,$all_day);

	# If coming in using 12-hr format, switch to 24-hour internally
	if (($schedule->{'start_time_ampm'} eq "am") && ($schedule->{'start_time_hh'} == 12)) {
		$schedule->{'start_time_hh'} = 0;
		}
	elsif (($schedule->{'start_time_ampm'} eq "pm") && ($schedule->{'start_time_hh'} < 12)) {
		$schedule->{'start_time_hh'} += 12;
		}
	if (($schedule->{'end_time_ampm'} eq "am") && ($schedule->{'end_time_hh'}== 12)) {
		$schedule->{'end_time_hh'} = 0;
		}
	elsif (($schedule->{'end_time_ampm'} eq "pm") && ($schedule->{'end_time_hh'} < 12)) {
		$schedule->{'end_time_hh'} += 12;
		}
		
	# Recurring schedule
	if ($schedule->{'type'} eq $RECURRING) {
		if ($schedule->{'recurring_start_date'}=~/^(\d\d\d\d)(\d\d)(\d\d)$/o) {
			$schedule->{'recurring_start_date'} = Time::Local::timegm(0,0,0,$3,${2}-1,$1);
			}
		if ($schedule->{'recurring_end_date'}=~/^(\d\d\d\d)(\d\d)(\d\d)$/o) {
			$schedule->{'recurring_end_date'} = Time::Local::timegm(59,59,23,$3,${2}-1,$1);
			}
		my ($recurrence_type) = $schedule->{'recurring_type'};
		$all_day = $schedule->{'all_day'};
		unless ($all_day) {
			$start_time = &LZ($schedule->{'start_time_hh'}) . &LZ($schedule->{'start_time_mm'});
			$end_time   = &LZ($schedule->{'end_time_hh'})   . &LZ($schedule->{'end_time_mm'});
			}

		if ($recurrence_type eq $WEEKLY) {
			$month = "";
			$date = "";
			$wday = join("," , grep /\d/, ($schedule->{'recurring_weekly_0'},$schedule->{'recurring_weekly_1'},$schedule->{'recurring_weekly_2'},$schedule->{'recurring_weekly_3'},$schedule->{'recurring_weekly_4'},$schedule->{'recurring_weekly_5'},$schedule->{'recurring_weekly_6'}));
			$which = "";
			}
		elsif ($recurrence_type eq $MONTHLY) {
			if ($schedule->{'recurring_monthly_type'} eq $RELATIVE) {
				$month = "";
				$date = "";
				$wday = $schedule->{'recurring_monthly_day'};
				$which = $schedule->{'recurring_monthly_occurrence'};
				}
			else {
				$month = "";
				$date = $schedule->{'recurring_monthly_date'};
				$wday = "";
				$which = "";
				}
			}
		elsif ($recurrence_type eq $YEARLY) {
			if ($schedule->{'recurring_yearly_type'} eq $RELATIVE) {
				$month = $schedule->{'recurring_yearly_month'};
				$date = "";
				$wday = $schedule->{'recurring_yearly_day'};
				$which = $schedule->{'recurring_yearly_occurrence'};
				}
			else {
				$month = $schedule->{'recurring_yearly_every_month'};
				$date = $schedule->{'recurring_yearly_date'};
				$wday = "";
				$which = "";
				}
			}
			
		# If it's a bounded event, figure all occurrences now
		my ($start) = $schedule->{'recurring_start_date'};
		my ($end) = $schedule->{'recurring_end_date'};
		if ($schedule->{'recurring_bounds'} && ($start ne "") && ($end ne "")) {
			my ($recurrence_id) = $event_id.time;
			my ($recurring_schedule) = join("|",$start,$end,$recurrence_type,$month,$date,$wday,$which);
			$schedule = &getRecurrenceTimes(
								{	
									'start'=>$start,
									'end'=>$end,
									'recurrence_type'=>$recurrence_type,
									'month'=>&UNLZ($month),
									'date'=>&UNLZ($date),
									'day'=>$wday,
									'which'=>$which,
									'start_time'=>$start_time,
									'end_time'=>$end_time,
									'all_day'=>$all_day
								}
									);
			foreach $occurrence (@$schedule) {
				if (!$db->addRecord( { 'event_id'=>$event_id, 
								'start'=>$occurrence->{'start'},
								'end'=>$occurrence->{'end'},
								'recurrence_type'=>$recurrence_type,
								'recurrence_id'=>$recurrence_id,
								'month'=>&UNLZ($occurrence->{'month'}),
								'date'=>&UNLZ($occurrence->{'date'}),
								'day'=>"",
								'which'=>"",
								'all_day'=>$occurrence->{'all_day'},
								'start_time'=>$occurrence->{'s_hh'} . $occurrence->{'s_mi'},
								'end_time'=>$occurrence->{'e_hh'} . $occurrence->{'e_mi'},
								'recurring_schedule'=>$recurring_schedule
								})) {
					&setErrorMessage(&main::getMessage("EVENT_SAVE_ERROR",$db->getErrorMessage()));
					return 0;
					}
				$recurring_schedule='';
				}
			}
		# Otherwise just add the recurring event to the schedule
		else {
			if (!$db->addRecord( { 'event_id'=>$event_id, 
							'start'=>$start,
							'end'=>$end,
							'recurrence_type'=>$recurrence_type,
							'recurrence_id'=>"",
							'month'=>&UNLZ($month),
							'date'=>&UNLZ($date),
							'day'=>$wday,
							'which'=>$which,
							'all_day'=>$all_day,
							'start_time'=>$start_time,
							'end_time'=>$end_time
							})) {
				&setErrorMessage(&main::getMessage("EVENT_SAVE_ERROR",$db->getErrorMessage()));
				return 0;
				}
			}
		}
	
	# Static schedule
	else {
#		my (@start_dates) = split(",", $schedule->{'static_start_date'});
		my (@start_dates);
		if ($schedule->{'static_dates_range'} eq "dates") {
			@start_dates = split(",", $schedule->{'static_dates'});
			}
		else {
			@start_dates = split(",", $schedule->{'static_start_date'});
			}

		my ($start,$end,$yy,$mm,$dd);
		$all_day = $schedule->{'all_day'};
		$end = 0;
		unless ($all_day) {
			$start_time = &LZ($schedule->{'start_time_hh'}) . &LZ($schedule->{'start_time_mm'});
			$end_time   = &LZ($schedule->{'end_time_hh'})   . &LZ($schedule->{'end_time_mm'});
			}
		if ($schedule->{'static_end_date'}=~/^(\d\d\d\d)(\d\d)(\d\d)$/o) {
			if ($all_day) {
				$end = Time::Local::timegm(0,59,23,$3,${2}-1,$1);
				}
			else {
				$end = Time::Local::timegm(0,$schedule->{'end_time_mm'},$schedule->{'end_time_hh'},$3,${2}-1,$1);
				}
			}
		foreach $start (@start_dates) {
			if ($start =~ /^(\d\d\d\d)(\d\d)(\d\d)$/o) {
				($yy,$mm,$dd) = ($1,$2,$3);
				$start = Time::Local::timegm(0,$schedule->{'start_time_mm'},$schedule->{'start_time_hh'},$dd,$mm-1,$yy);
				}
			if ($schedule->{'static_dates_range'} eq "dates") {
				$end = $start;
				}
			if (!$end && $all_day) {
				$end = $start;
				}
			elsif (!$end) {
				$end = Time::Local::timegm(0,$schedule->{'end_time_mm'},$schedule->{'end_time_hh'},$dd,$mm-1,$yy);
				}
			#if (!$schedule->{'static_end_date'} && $all_day) {
			#	$schedule->{'static_end_date'} = $start;
			#	}
			if (!$db->addRecord( { 'event_id'=>$event_id, 
							'start'=>$start,
							'end'=>$end,
							'recurrence_type'=>'',
							'recurrence_id'=>'',
							'month'=>&UNLZ($mm),
							'date'=>&UNLZ($dd),
							'day'=>'',
							'which'=>'',
							'all_day'=>$all_day,
							'start_time'=>$start_time,
							'end_time'=>$end_time
							})) {
				&setErrorMessage(&main::getMessage("EVENT_SAVE_ERROR",$db->getErrorMessage()));
				return 0;
				}
			}
		}

	return 1;
	}

# Get the next occurrence of an event schedule
# --------------------------------------------
sub getNextOccurrence {
	my ($schedule,$start,$end) = @_;
	unless ($start) {
		$start = Time::Local::timegm(localtime(time));
		}
	unless ($end) {
		$end = $start + 31536000;
		}
	unless ($schedule) { return 0; }
	my ($time);
	%$tmp_schedule = %$schedule;
	if ($tmp_schedule->{'start'}) {
		$time = $tmp_schedule->{'start'};
		}
	else {
		$tmp_schedule->{'start'} = $start;
		$tmp_schedule->{'end'} = $end;
		$time = &getRecurrenceTimes($tmp_schedule,1);
		$time = $time->{'start'};
		}
	my ($occurrence,$x);
	if (($time < $start) || ($time > $end)) {
		return 0;
		}
	$occurrence->{'start'} = $time;
	($x,$occurrence->{'mi'},$occurrence->{'hh'},$occurrence->{'date'},$occurrence->{'month'},$occurrence->{'year'},$occurrence->{'wd'},$occurrence->{'yd'},$x) = gmtime($time);
	$occurrence->{'month'}++;
	$occurrence->{'year'} = $occurrence->{'year'} + 1900;
	$occurrence->{'wd'}++;
	return $occurrence;
	}

# Get a text description of an event's schedule
# ---------------------------------------------
sub getScheduleDescription {
	my ($schedule) = @_;
	return "";
	}

# Get the start/end time values for recurring events
# --------------------------------------------------
sub getRecurrenceTimes {
	my ($schedule,$max_matches) = @_;
	my ($start) = $schedule->{'start'};
	my ($end) = $schedule->{'end'};
	my ($recurrence_type) = $schedule->{'recurrence_type'};
	my ($month) = $schedule->{'month'};
	my ($mday) = $schedule->{'date'};
	my ($wday) = $schedule->{'day'};
	my ($which) = $schedule->{'which'};
	my ($start_time) = $schedule->{'start_time'};
	my ($end_time) = $schedule->{'end_time'};
	my ($all_day) = $schedule->{'all_day'};
	my (%days_in_month) = (1=>31,2=>28,3=>31,4=>30,5=>31,6=>30,7=>31,8=>31,9=>30,10=>31,11=>30,12=>31);

	# CHECK FOR VALID INPUT!
	# TODO
	
	my ($dst_change,$values);
	my ($tmp_s_time,$tmp_e_time);

	my($s_ss,$s_mi,$s_hh,$s_dd,$s_mm,$s_yy,$s_wd,$s_yd,$s_dst) = gmtime($start);
	my($e_ss,$e_mi,$e_hh,$e_dd,$e_mm,$e_yy,$e_wd,$e_yd,$e_dst) = gmtime($end);
	
	$s_mm++; $e_mm++;
	$s_yy+=1900; $e_yy+=1900;
	
	if ($all_day) {
		$start_time = "0000";
		$end_time = "2359";
		}
	my ($start_time_hh,$start_time_mm) = ($start_time =~ /(\d\d)(\d\d)/);
	my ($end_time_hh,  $end_time_mm)   = (  $end_time =~ /(\d\d)(\d\d)/);
	
	# RECURRING WEEKLY
	# ----------------
	if ($recurrence_type eq $WEEKLY) {
		my ($wdays);
		grep { $wdays->{$_}=1; } split(/,/,$wday);
		my ($wd) = $s_wd;
		my ($dd) = $s_dd;
		my ($yy) = $s_yy;
		my ($mm) = $s_mm;
		if (&Date::isLeapYear($s_yy)) { $days_in_month{2}=29; }
		my ($time) = 0;
		while ($time < $end) {
		#if ($loopcount++ > 5000){ print "Too many loops in getRecurrenceTimes(). Please contact admin@calendarscript.com."; &main::exitGracefully(); }
		if ($wdays->{$wd}) {
				# EVENT OCCURS ON THIS DAY
				$tmp_s_time = Time::Local::timegm(0,$start_time_mm,$start_time_hh,$dd,$mm-1,$yy);
				$tmp_e_time = Time::Local::timegm(0,$end_time_mm,$end_time_hh,$dd,$mm-1,$yy);
				if (($tmp_s_time <= $end) && ($tmp_e_time >= $start)) {
					push(@$values, {'start'=>$tmp_s_time,'end'=>$tmp_e_time,'year'=>$yy,'month'=>$mm,'date'=>$dd,'s_hh'=>$start_time_hh,'s_mi'=>$start_time_mm,'e_hh'=>$end_time_hh,'e_mi'=>$end_time_mm,'all_day'=>$all_day });
					if (($max_matches > 0) && ($#$values+1 == $max_matches)) { return $values->[0]; }
					}
				$time = $tmp_s_time;
				}
			# Increment weekday
			$wd++;
			if ($wd > 6) { $wd=0; }
			# Increment date/month/year
			$dd++;
			if ($dd > $days_in_month{$mm}) {
				$dd=1;
				$mm++;
				if ($mm>12) {
					$mm=1;
					$yy++;
					if (&Date::isLeapYear($yy)) { 
						$days_in_month{2}=29; 
						}
					else {
						$days_in_month{2}=28;
						}
					}
				}
			}
		return $values;
		}
		
	# RECURRING MONTHLY
	# -----------------
	elsif ($recurrence_type eq $MONTHLY) {
		my ($mm) = $s_mm;
		my ($yy) = $s_yy;
		my ($dd) = 1;
		my ($wd) = (gmtime(Time::Local::timegm(0,0,0,1,$mm-1,$yy)))[6];
		if (&Date::isLeapYear($s_yy)) { $days_in_month{2}=29; }
		my ($time) = 0;
		my ($match_num) = 0;
		
		# First, second, last, etc
		# ------------------------
		if ($which ne "") {
			my ($match_mm,$match_dd,$match_wd) = (-1,-1,-1);
			my ($last_mm,$last_dd) = (-1,-1);
			while ($time < $end) {
				# Is this day a match?
				if ( ($which > 0) && (($wday eq "") || ($wd==$wday)) ) {
					$match_num++;
					if ($match_num == $which) { # Found which occurence we're looking for
						$tmp_s_time = Time::Local::timegm(0,$start_time_mm,$start_time_hh,$dd,$mm-1,$yy);
						$tmp_e_time = Time::Local::timegm(0,$end_time_mm,$end_time_hh,$dd,$mm-1,$yy);
						if (($tmp_s_time <= $end) && ($tmp_s_time >= $start)) {
							push(@$values, {'start'=>$tmp_s_time,'end'=>$tmp_e_time,'year'=>$yy,'month'=>$mm,'date'=>$dd,'s_hh'=>$start_time_hh,'s_mi'=>$start_time_mm,'e_hh'=>$end_time_hh,'e_mi'=>$end_time_mm,'all_day'=>$all_day });
							if (($max_matches > 0) && ($#$values+1 == $max_matches)) { return $values->[0]; }
							}
						$time = $tmp_s_time;
						}
					}
				elsif ( ($which<0) && (($wday eq "") || ($wd==$wday)) ) {
					$last_mm = $mm;
					$last_dd = $dd;
					$last_yy = $yy;
					}
				# Increment weekday
				$wd++;
				if ($wd > 6) { $wd=0; }
				# Increment date/month/year
				$dd++;
				if ($dd > $days_in_month{$mm}) {
					$dd=1;
					$mm++;
					if ($mm>12) {
						$mm=1;
						$yy++;
						if (&Date::isLeapYear($yy)) { 
							$days_in_month{2}=29; 
							}
						else {
							$days_in_month{2}=28;
							}
						}
					if (($last_dd != -1)) {
						$tmp_s_time = Time::Local::timegm(0,$start_time_mm,$start_time_hh,$last_dd,$last_mm-1,$last_yy);
						$tmp_e_time = Time::Local::timegm(0,$end_time_mm,$end_time_hh,$last_dd,$last_mm-1,$last_yy);
						if (($tmp_s_time <= $end) && ($tmp_s_time >= $start)) {
							push(@$values, {'start'=>$tmp_s_time,'end'=>$tmp_e_time,'year'=>$last_yy,'month'=>$last_mm,'date'=>$last_dd,'s_hh'=>$start_time_hh,'s_mi'=>$start_time_mm,'e_hh'=>$end_time_hh,'e_mi'=>$end_time_mm,'all_day'=>$all_day });
							if (($max_matches > 0) && ($#$values+1 == $max_matches)) { return $values->[0]; }
							}
						$time = $tmp_s_time;
						}
					$last_mm=-1;
					$last_dd=-1;
					$last_yy=-1;
					$match_num=0;
					}
				}
			}
		# Normal month date
		# -----------------
		else {
			while ($time < $end) {
				if ($mday <= $days_in_month{$mm}) {
					$tmp_s_time = Time::Local::timegm(0,$start_time_mm,$start_time_hh,$mday,$mm-1,$yy);
					$tmp_e_time = Time::Local::timegm(0,$end_time_mm,$end_time_hh,$mday,$mm-1,$yy);
					if (($tmp_s_time <= $end) && ($tmp_s_time >= $start)) {
						push(@$values, {'start'=>$tmp_s_time,'end'=>$tmp_e_time,'year'=>$yy,'month'=>$mm,'date'=>$mday,'s_hh'=>$start_time_hh,'s_mi'=>$start_time_mm,'e_hh'=>$end_time_hh,'e_mi'=>$end_time_mm,'all_day'=>$all_day });
						if (($max_matches > 0) && ($#$values+1 == $max_matches)) { return $values->[0]; }
						}
					$time = $tmp_s_time;
					}
				$mm++;
				if ($mm>12) {
					$mm=1;
					$yy++;
					if (&Date::isLeapYear($yy)) { 
						$days_in_month{2}=29; 
						}
					else {
						$days_in_month{2}=28;
						}
					}
				}
			}
		return $values;
		}
	
	# RECURRING YEARLY
	# ----------------
	elsif ($recurrence_type eq $YEARLY) {
		my ($mm) = $month;
		my ($yy) = $s_yy;
		my ($dd) = 1;
		if (&Date::isLeapYear($s_yy)) { $days_in_month{2}=29; }
		my ($time) = 0;
		my ($match_num) = 0;
		
		# First, second, last, etc
		# ------------------------
		if ($which ne "") {
			my ($match_mm,$match_dd,$match_wd) = (-1,-1,-1);
			my ($last_mm,$last_dd) = (-1,-1);
			my ($wd) = (gmtime(Time::Local::timegm(0,0,0,1,$mm-1,$yy)))[6];
			while ($time < $end) {
				# Is this day a match?
				if ( ($which > 0) && (($wday eq "") || ($wd==$wday)) ) {
					$match_num++;
					if ($match_num == $which) { # Found which occurence we're looking for
						$tmp_s_time = Time::Local::timegm(0,$start_time_mm,$start_time_hh,$dd,$mm-1,$yy);
						$tmp_e_time = Time::Local::timegm(0,$end_time_mm,$end_time_hh,$dd,$mm-1,$yy);
						if (($tmp_s_time <= $end) && ($tmp_s_time >= $start)) {
							push(@$values, {'start'=>$tmp_s_time,'end'=>$tmp_e_time,'year'=>$yy,'month'=>$mm,'date'=>$dd,'s_hh'=>$start_time_hh,'s_mi'=>$start_time_mm,'e_hh'=>$end_time_hh,'e_mi'=>$end_time_mm,'all_day'=>$all_day });
							if (($max_matches > 0) && ($#$values+1 == $max_matches)) { return $values->[0]; }
							}
						$time = $tmp_s_time;
						}
					}
				elsif ( ($which<0) && (($wday eq "") || ($wd==$wday)) ) {
					$last_mm = $mm;
					$last_dd = $dd;
					$last_yy = $yy;
					}
				# Increment weekday
				$wd++;
				if ($wd > 6) { $wd=0; }
				# Increment date/month/year
				$dd++;
				if ($dd > $days_in_month{$mm}) {
					$yy++;
					$dd=1;
					$wd = (gmtime(Time::Local::timegm(0,0,0,1,$mm-1,$yy)))[6];
					if (&Date::isLeapYear($yy)) { 
						$days_in_month{2}=29; 
						}
					else {
						$days_in_month{2}=28;
						}
					if (($last_dd != -1)) {
						$tmp_s_time = Time::Local::timegm(0,$start_time_mm,$start_time_hh,$last_dd,$last_mm-1,$last_yy);
						$tmp_e_time = Time::Local::timegm(0,$end_time_mm,$end_time_hh,$last_dd,$last_mm-1,$last_yy);
						if (($tmp_s_time <= $end) && ($tmp_s_time >= $start)) {
							push(@$values, {'start'=>$tmp_s_time,'end'=>$tmp_e_time,'year'=>$last_yy,'month'=>$last_mm,'date'=>$last_dd,'s_hh'=>$start_time_hh,'s_mi'=>$start_time_mm,'e_hh'=>$end_time_hh,'e_mi'=>$end_time_mm,'all_day'=>$all_day });
							if (($max_matches > 0) && ($#$values+1 == $max_matches)) { return $values->[0]; }
							}
						$time = $tmp_s_time;
						}
					$last_mm=-1;
					$last_dd=-1;
					$last_yy=-1;
					$match_num=0;
					}
				}
			}
		# Normal month date
		# -----------------
		else {
			while ($time < $end) {
				if ($mday <= $days_in_month{$month}) {
					$tmp_s_time = Time::Local::timegm(0,$start_time_mm,$start_time_hh,$mday,$month-1,$yy);
					$tmp_e_time = Time::Local::timegm(0,$end_time_mm,$end_time_hh,$mday,$month-1,$yy);
					if (($tmp_s_time <= $end) && ($tmp_s_time >= $start)) {
						push(@$values, {'start'=>$tmp_s_time,'end'=>$tmp_e_time,'year'=>$yy,'month'=>$month,'date'=>$mday,'s_hh'=>$start_time_hh,'s_mi'=>$start_time_mm,'e_hh'=>$end_time_hh,'e_mi'=>$end_time_mm,'all_day'=>$all_day });
						if (($max_matches > 0) && ($#$values+1 == $max_matches)) { return $values->[0]; }
						}
					$time = $tmp_s_time;
					}
				$yy++;
				if (&Date::isLeapYear($yy)) { 
					$days_in_month{2}=29; 
					}
				else {
					$days_in_month{2}=28;
					}
				}
			}
		return $values;
	
		}
	}



1;
