# Date functions
package Date;

%days_in_month = (1=>31,2=>28,3=>31,4=>30,5=>31,6=>30,7=>31,8=>31,9=>30,10=>31,11=>30,12=>31);
sub LZ { my($x)=shift;if(length($x)==1){return "0$x";}return $x; }

# Check if a year is a leap year
# ------------------------------
sub isLeapYear {
	my ($year) = shift;
	my ($result) = 0;
	if (($year % 4) == 0) {
		$result = 1;
		if (($year % 100) == 0) {
			$result = 0;
			}
		if (($year % 400) == 0) {
			$result = 1;
			}
		}
	return $result;
	}

# Get number of days in the month for given month/year
# ----------------------------------------------------
sub getDaysInMonth {
	my ($year,$month) = @_;
	$year += 0;
	$month += 0;
	if ($month==2 && &isLeapYear($year)) {
		return $days_in_month{$month}++;
		}
	else {
		return $days_in_month{$month};
		}
	}

# Fix end time for Daylight Savings Time when adding seconds
# DST is such a pain!!! Get rid of it!!
# ----------------------------------------------------------
sub fixDST {
	my ($s,$e) = @_;
	my $sdst = (localtime($s+$main::localtime_offset))[8] > 0;
	my $edst = (localtime($e+$main::localtime_offset))[8] > 0;
	$e -= ($edst - $sdst) * 60 * 60;
	return ($s,$e);
	}

# Turn a time value into YYYYMMDD
# -------------------------------
sub timeToDate {
	my ($time) = @_;
	my ($ss,$mi,$hh,$dd,$mm,$yy,$wd,$yd,$isdst) = gmtime($time);
	$yy+=1900; $mm++;
	return $yy.&LZ($mm).&LZ($dd);
	}

# Turn an HHMM time into HH:MM amp/pm depending on 12/24
# ------------------------------------------------------
sub formatTime {
	my ($time,$format) = @_;
	if ($time eq "") { return ""; }
	if ($time > 2359) { return ""; }
	my ($hh,$mm,$ampm);
	($hh,$mm) = ($time =~ /(..)(..)/);
	if ($format eq "12") {
		if ($hh>11) { $ampm = "pm"; } else { $ampm = "am"; }
		if ($hh>12) { $hh = $hh - 12; }
		if ($hh == 0) { $hh = 12; }
		$hh+=0;
		return "$hh:$mm $ampm";
		}
	else {
		$hh+=0;
		return "$hh:$mm";
		}
	}

# Find next month/year for given month/year
# -----------------------------------------
sub getNextMonthYear {
	my ($year,$month) = @_;
	$month++;
	if ($month > 12) { 
		$year++;
		$month=1;
		}
	return ($year,$month);
	}

# Find last month/year for given month/year
# -----------------------------------------
sub getLastMonthYear {
	my ($year,$month) = @_;
	$month--;
	if ($month < 1) { 
		$year--;
		$month=12;
		}
	return ($year,$month);
	}

# Find date of yesterday
# ----------------------
sub getYesterday {
	my ($year,$month,$date) = @_;
	if ($date == 1) {
		($year,$month) = &getLastMonthYear($year,$month);
		$date = &getDaysInMonth($year,$month);
		return ($year,$month,$date);
		}
	return ($year,$month,$date-1);
	}

# Find date of tomorrow
# ---------------------
sub getTomorrow {
	my ($year,$month,$date) = @_;
	$date++;
	if ($date > &getDaysInMonth($year,$month)) {
		($year,$month) = &getNextMonthYear($year,$month);
		$date = 1;
		return ($year,$month,$date);
		}
	return ($year,$month,$date);
	}

# Find date of next week
# ----------------------
sub getNextWeek {
	my ($year,$month,$date) = @_;
	$date+=7;
	if ($date > &getDaysInMonth($year,$month)) {
		$date -= &getDaysInMonth($year,$month);
		($year,$month) = &getNextMonthYear($year,$month);
		return ($year,$month,$date);
		}
	return ($year,$month,$date);
	}

# Find date of last week
# ----------------------
sub getLastWeek {
	my ($year,$month,$date) = @_;
	$date-=7;
	if ($date < 1) {
		($year,$month) = &getLastMonthYear($year,$month);
		$date = &getDaysInMonth($year,$month) + $date;
		return ($year,$month,$date);
		}
	return ($year,$month,$date);
	}

# Get time span for given parameters
# ----------------------------------
sub getTimeSpan {
	my ($properties) = @_;
	my ($start,$end,$duration,$range,$startdate,$enddate,$week_start_day);
	$start = $properties->{'start'};
	$end = $properties->{'end'};
	$duration = $properties->{'duration'};
	$range = $properties->{'range'};
	$startdate = $properties->{'startdate'};
	$enddate = $properties->{'enddate'};
	$week_start_day = $main::Config->get("week_start_day");
	my ($start_ss,$start_mi,$start_hh,$start_dd,$start_mm,$start_yy,$start_wd,$start_yd,$start_isdst);
	my ($end_ss,$end_mi,$end_hh,$end_dd,$end_mm,$end_yy,$end_wd,$end_yd,$end_isdst);
	if ($week_start_day eq "") {
		$week_start_day = 0;
		}
	if ($start && $end) {
		return ($start,$end);
		}
	# Get starting point
	if ($start eq "today") {
		$start = time+$main::localtime_offset;
		($start_ss,$start_mi,$start_hh,$start_dd,$start_mm,$start_yy,$start_wd,$start_yd,$start_isdst) = localtime($start);
		$start_yy+=1900;
		$start_mm++;
		$start_ss = $start_mi = $start_hh = 0;
		$start = Time::Local::timegm($start_ss,$start_mi,$start_hh,$start_dd,$start_mm-1,$start_yy);
		}
	elsif ($start) {
		($start_ss,$start_mi,$start_hh,$start_dd,$start_mm,$start_yy,$start_wd,$start_yd,$start_isdst) = gmtime($start);
		$start_yy+=1900;
		$start_mm++;
		}
	elsif ($startdate) {
		($start_yy,$start_mm,$start_dd) = ($startdate =~ /(\d\d\d\d)(\d\d)(\d\d)/);
		$start_ss=$start_mi=$start_hh=0;
		$start = Time::Local::timegm($start_ss,$start_mi,$start_hh,$start_dd,$start_mm-1,$start_yy);
		($start_ss,$start_mi,$start_hh,$start_dd,$start_mm,$start_yy,$start_wd,$start_yd,$start_isdst) = gmtime($start);
		$start_yy+=1900;
		$start_mm++;
		}
	else {
		$start = time+$main::localtime_offset;
		($start_ss,$start_mi,$start_hh,$start_dd,$start_mm,$start_yy,$start_wd,$start_yd,$start_isdst) = localtime($start);
		$start = Time::Local::timegm(localtime($start));
		$start_yy+=1900;
		$start_mm++;
		}

	# If end time or end date are specified return start->end
	if ($end) {
		return ($start,$end);
		}
	elsif ($enddate) {
		($end_yy,$end_mm,$end_dd) = ($enddate =~ /(\d\d\d\d)(\d\d)(\d\d)/);
		$end_ss=59;
		$end_mi=59;
		$end_hh=23;
		$end = Time::Local::timegm($end_ss,$end_mi,$end_hh,$end_dd,$end_mm-1,$end_yy);
		return ($start,$end);
		}
		
	# Check duration - it takes precedence over range
	if ($duration ne "") {
		if ($duration =~ /^(\d+)([hdw])$/) {
			my ($count,$type) = ($1,$2);
			$type = lc($type);
			my ($sec) = 0;
			if ($type eq "h") {
				$sec = 3600;
				}
			elsif ($type eq "d") {
				$sec = 86400;
				}
			elsif ($type eq "w") {
				$sec = 604800;
				}
			$sec *= $count;
			$end = $start + $sec - 1;
#			($start,$end) = &fixDST($start,$end);
			return ($start,$end);
			}
		}

	# Next check the range
	$range = lc($range);
	if ($range eq "day") {
		$start = Time::Local::timegm(0,0,0,$start_dd,$start_mm-1,$start_yy);
		$end   = Time::Local::timegm(59,59,23,$start_dd,$start_mm-1,$start_yy);
		return ($start,$end);
		}
	# The definition of "this week" differs depending on country - some countries start weeks on mon, etc. WHY?!?!
	elsif (($range eq "week") || ($range eq "twoweek") || ($range eq "threeweek") || ($range eq "fourweek")) {
		$start = Time::Local::timegm(0,0,0,$start_dd,$start_mm-1,$start_yy);
		my ($offset_days);
		if ($start_wd >= $week_start_day) {
			$offset_days = $start_wd - $week_start_day;
			}
		elsif ($start_wd < $week_start_day) {
			$offset_days = 7-$week_start_day+$start_wd;
			}
		$start = $start - (86400*$offset_days);
		if ($range eq "week") {
			$offset_days = 7;
			}
		elsif ($range eq "twoweek") {
			$offset_days = 14;
			}
		elsif ($range eq "threeweek") {
			$offset_days = 21;
			}
		elsif ($range eq "fourweek") {
			$offset_days = 28;
			}
		$end = $start + (86400*$offset_days)-1;
#		($start,$end) = &fixDST($start,$end);
		return ($start,$end);
		}
	elsif ($range eq "year") {
		$start = Time::Local::timegm(0,0,0,1,0,$start_yy);
		$end   = Time::Local::timegm(59,59,23,31,11,$start_yy);
		return ($start,$end);
		}
		
	# Default to monthly range (makes sense for a calendar, no?)
	$start = Time::Local::timegm(0,0,0,1,$start_mm-1,$start_yy);
	if ($start_mm == 12) { 
		$start_mm=0; $start_yy++; 
		}
	$end   = Time::Local::timegm(0,0,0,1,$start_mm,$start_yy)-1;
	return ($start,$end);
	}
	
1;