#####################################################################
# Provide utilities for using DBFile.pm
#####################################################################

#####################################################################
# DBGetFieldsInDisplayOrder
#   Return a list of field names in display order
#####################################################################
sub DBGetFieldsInDisplayOrder {
	my ($db) = @_;
	my (@fields) = keys %{$db->{'fieldindex'}};
	@fields = sort {($db->{'properties'}->{$a}->{'displayorder'}||999) <=> ($db->{'properties'}->{$b}->{'displayorder'}||999)} @fields;
	return \@fields;
	}

#####################################################################
# DBGetAddFields
#   Return a list of field names in display order for use in add form
#####################################################################
sub DBGetAddFields {
	my ($db) = @_;
	my (@fields);
	foreach (keys %{$db->{'fieldindex'}}) {
		if (exists $db->{'properties'}->{$_}->{'display'}) {
			if ($db->{'properties'}->{$_}->{'display'}) {
				push (@fields,$_);
				}
			}
		else {
			push(@fields,$_);
			}
		}
	@fields = sort {($db->{'properties'}->{$a}->{'displayorder'}||999) <=> ($db->{'properties'}->{$b}->{'displayorder'}||999)} @fields;
	return \@fields;
	}

#####################################################################
# DBGetSearchFields
#   Return a list of field names in display order for use in search form
#####################################################################
sub DBGetSearchFields {
	my ($db) = @_;
	my (@fields);
	foreach (keys %{$db->{'fieldindex'}}) {
		if (exists $db->{'properties'}->{$_}->{'searchable'}) {
			if ($db->{'properties'}->{$_}->{'searchable'}) {
				push (@fields,$_);
				}
			}
		}
	@fields = sort {($db->{'properties'}->{$a}->{'displayorder'}||999) <=> ($db->{'properties'}->{$b}->{'displayorder'}||999)} @fields;
	return \@fields;
	}

#####################################################################
# GetFieldInput
#   Return an HTML input element for a field, based on its properties
#   Pass field name as second parameter
#   Optionally pass record as third to populate form value
#####################################################################
sub GetFieldInput {
	my ($field,$name,$record) = @_;
	my ($input);
	my ($type) = $field->{'type'} || "text";

	# Define input field based on type
	if (($type =~ /^text(?!area)/) || ($type =~ /^password/)) {
		my ($defaultvalue,$onchange);
		if (exists $record->{$name}) {
			$defaultvalue = $record->{$name};
			}
		else {
			$defaultvalue = $field->{'defaultvalue'};
			}
		my ($size) = $field->{'size'} || 30;
		my ($maxlength);
		if ((defined $field->{'maxlength'}) && ($field->{'maxlength'}==0)) { $maxlength = ""; }
		elsif ($field->{'maxlength'}) { $maxlength = $field->{'maxlength'}; }
		else { $field->{'maxlength'} = $size; }
		if ($type eq "password") {
			$onchange = "onChange=\"this.form.CONFIRM_$name.focus();\" onBlur=\"this.form.CONFIRM_$name.focus();\""
			}
		$input .= "<INPUT TYPE=\"$type\" NAME=\"FIELD_$name\" SIZE=\"$size\" MAXLENGTH=\"$maxlength\" VALUE=\"".&HTML::encodeHTML($defaultvalue)."\" $onchange>";
		if ($type eq "password") {
			$onchange = "if (this.value!=this.form.FIELD_$name.value) { if(confirm('Passwords do not match!\\n\\n - Click OK to re-edit the password\\n - Click CANCEL to clear both password boxes')) { this.focus();this.select();return false; } else { this.form.FIELD_${name}.value='';this.value='';this.form.FIELD_${name}.focus();return true; } }";
			$input .= &main::getMessage("CONFIRM").": <INPUT TYPE=\"$type\" NAME=\"CONFIRM_$name\" SIZE=\"$size\" MAXLENGTH=\"$maxlength\" VALUE=\"".&HTML::encodeHTML($defaultvalue)."\" onBlur=\"$onchange\">";
			}
		}
	elsif ($type =~ /^textarea/) {
		my ($defaultvalue);
		if (exists $record->{$name}) {
			$defaultvalue = $record->{$name};
			}
		else {
			$defaultvalue = $field->{'defaultvalue'};
			}
		my ($rows) = $field->{'rows'} || 4;
		my ($cols) = $field->{'cols'} || 40;
		$input .= "<TEXTAREA NAME=\"FIELD_$name\" ROWS=\"$rows\" COLS=\"$cols\">".&HTML::encodeHTML($defaultvalue)."</TEXTAREA>";
		}
	elsif ($type =~ /^checkbox/) {
		my ($checked);
		if (exists $record->{$name}) {
			$checked = ($record->{$name})?"CHECKED":"";
			}
		else {
			$checked = ($field->{'defaultchecked'})?"CHECKED":"";
			}
		$input .= "<INPUT TYPE=\"checkbox\" NAME=\"FIELD_$name\" VALUE=\"".&HTML::encodeHTML($field->{checkedvalue})."\" $checked>";
		}
	elsif ($type =~ /^select/) {
		my (@options) = split(";",$field->{'options'});
		my ($size) = $field->{'size'} || 1;
		my ($multiple) = ($field->{'multiple'})?"MULTIPLE":"";
		my ($text,$value,$selected);
		$input .= "<SELECT NAME=\"FIELD_$name\" SIZE=\"$size\" $multiple>";
		while ($#options>0) {
			$text = shift(@options);
			$value = shift(@options);
			if ((exists $record->{$name}) && ($record->{$name} eq $value)) {
				$selected = "SELECTED";
				}
			elsif (exists $record->{$name}) {
				$selected = "";
				}
			elsif ($field->{'defaultvalue'} eq $value) {
				$selected = "SELECTED";
				}
			else {
				$selected = "";
				}
			$input .= "<OPTION VALUE=\"".&HTML::encodeHTML($value)."\" $selected>$text</OPTION>";
			}
		$input .= "</SELECT>";
		}
	elsif ($type =~ /^radio/) {
		my (@options) = split(";",$field->{'options'});
		my ($text,$value,$selected);
		while ($#options>0) {
			$text = shift(@options);
			$value = shift(@options);
			if ((exists $record->{$name}) && ($record->{$name} eq $value)) {
				$selected = "CHECKED";
				}
			elsif (exists $record->{$name}) {
				$selected = "";
				}
			elsif ($field->{'defaultvalue'} eq $value) {
				$selected = "CHECKED";
				}
			else {
				$selected = "";
				}
			$input .= "<INPUT NAME=\"FIELD_$name\" TYPE=\"radio\" VALUE=\"".&HTML::encodeHTML($value)."\" $selected>&nbsp;".&HTML::encodeHTML($text)." ";
			}
		}
	elsif ($type =~ /^color/) {
		my ($defaultvalue,$onchange);
		if (exists $record->{$name}) {
			$defaultvalue = $record->{$name};
			}
		else {
			$defaultvalue = $field->{'defaultvalue'};
			}
		my ($size) = $field->{'size'} || 30;
		my ($maxlength) = $field->{'maxlength'} || $size;
		$input .= "<INPUT TYPE=\"text\" NAME=\"FIELD_$name\" SIZE=\"$size\" MAXLENGTH=\"$maxlength\" VALUE=\"".&HTML::encodeHTML($defaultvalue)."\">&nbsp;[<A NAME=\"ANCHOR_$name\" HREF=\"#\" onClick=\"colorInput('FIELD_$name','ANCHOR_$name');return false;\">Pick</A>]";
		}
	else {
		$input = &main::getMessage("INVALID_INPUT_TYPE",$type);
		}
	
	return $input;
	}

#####################################################################
# GetFieldProperties
#   Parse a file definition HTML fields
#####################################################################
sub GetFieldProperties {
	my ($prop) = @_;
	my ($fields,$arrayfields);
	my ($i,$field,$value,$name,$property);
	unless (-e $prop) { 
		$arrayfields = ();
		return $arrayfields;
		}
	open(PROPERTIES,$prop) || &FATALERROR(&main::getMessage("COULDNT_OPEN_TEMPLATE_PREFERENCES_FILE",$prop,$!));
	while (<PROPERTIES>) {
		next if /^#/;
		next if /^\s*$/;
		chomp;
		s/\s*$//;
		($field,$value) = ( /^\s*([^=]+)\s*=\s*"?(.*?)"?$/o );
		($name,$property) = ( $field =~ /([^:]*):(.*)/ );
		unless ($fields->{$name}->{'order'}) {
			$fields->{$name}->{'order'} = ++$i;
			$fields->{$name}->{'field_name'} = $name;
			}
		$fields->{$name}->{$property} = $value;
		}
	close(PROPERTIES);
	foreach $name (sort {$fields->{$a}->{'order'} <=> $fields->{$b}->{'order'}} keys %$fields) {
		push(@$arrayfields,$fields->{$name});
		}
	return $arrayfields;
	}

#####################################################################
# GetSearchFieldInput
#   Return an HTML input element for a field, based on its properties
#   Pass field name as second parameter
#   Optionally pass record as third to populate form value
#####################################################################
sub GetSearchFieldInput {
	my ($field,$name,$record) = @_;
	my ($input);
	my ($type) = $field->{'type'} || "text";

	# Define input field based on type
	if (($type =~ /^text(?!area)/) || ($type =~ /^password/) || ($type =~ /^textarea/)) {
		my ($defaultvalue);
		if (exists $record->{$name}) {
			$defaultvalue = $record->{$name};
			}
		my ($size) = $field->{'size'} || $field->{'cols'} || 30;
		my ($maxlength) = $field->{'maxlength'} || $size;
		$input .= "<INPUT TYPE=\"$type\" NAME=\"FIELD_$name\" SIZE=\"$size\" MAXLENGTH=\"$maxlength\" VALUE=\"".&HTML::encodeHTML($defaultvalue)."\">";
		}
	elsif ($type =~ /^checkbox/) {
		my ($checked);
		if (exists $record->{$name}) {
			$checked = ($record->{$name})?"CHECKED":"";
			}
		$input .= "<INPUT TYPE=\"checkbox\" NAME=\"FIELD_$name\" VALUE=\"".&HTML::encodeHTML($field->{checkedvalue})."\" $checked>";
		}
	elsif ($type =~ /^select/) {
		my (@options) = split(";",$field->{'options'});
		my ($size) = $field->{'size'} || 1;
		my ($multiple) = ($field->{'multiple'})?"MULTIPLE":"";
		my ($text,$value,$selected);
		$input .= "<SELECT NAME=\"FIELD_$name\" SIZE=\"$size\" $multiple>";
		$input .= "<OPTION VALUE=\"\"></OPTION>";
		while ($#options>0) {
			$text = shift(@options);
			$value = shift(@options);
			if ((exists $record->{$name}) && ($record->{$name} eq $value)) {
				$selected = "SELECTED";
				}
			elsif (exists $record->{$name}) {
				$selected = "";
				}
			$input .= "<OPTION VALUE=\"".&HTML::encodeHTML($value)."\" $selected>$text</OPTION>";
			}
		$input .= "</SELECT>";
		}
	else {
		$input = &main::getMessage("INVALID_INPUT_TYPE",$type);
		}
	
	return $input;
	}

1;
