package ConfigFile;

# New ConfigFile object
# ---------------------
sub new {
	my ($class,$file) = @_;
	my $self = bless { }, $class;
	if (-e $file) {
		$self->{'_file'} = $file;
		$self->{'_lockfile'} = $file.".lock";
		$self->read();
		return $self;
		}
	else {
		return undef;
		}
	}

# Error-handling
# --------------
sub setErrorMessage {
	my ($self,$msg) = @_;
	$self->{'errorMessage'} = $msg;
	}
sub getErrorMessage {
	my ($self) = @_;
	return $self->{'errorMessage'};
	}

# File-Locking routines
# ---------------------
sub lock {
	my ($self) = @_;
	unless(open(LOCK,"> $self->{_lockfile}")) {
		$self->setErrorMessage(&main::getMessage("CONFIG_COULD_NOT_OPEN_LOCK_FILE",$self->{_lockfile}));
		return 0;
		}
	eval("flock(LOCK, 2)");
	$self->{'_locked'} = 1;
	return 1;
	}
sub unlock {
	my ($self) = @_;
	eval("flock(LOCK, 8)");
	close(LOCK);
	$self->{'_locked'} = 0;
	return 1;
	}

# Read in a config file
# ---------------------
sub read {
	my ($self) = @_;
	my ($key,$val);
	unless(open(FILE,$self->{'_file'})) {
		$self->setErrorMessage(&main::getMessage("CONFIG_COULD_NOT_OPEN_READING",$self->{_file}));
		return 0;
		}
	while (<FILE>) {
		next if /^#/;
		chomp;
		($key,$val) = ( /^\s*([^=]+)\s*=\s*"?(.*?)"?$/o );
		$key =~ s|\s*$||;
		$val =~ s|\s*$||;
		next unless ($key);
		$key = lc($key);
		if ($val =~ /^ARRAY\((.*)\)$/) { # Array Format
			my (@tmp) = split(',',$1);
			$self->{$key} = \@tmp;
			}
		else {
			$val =~ s/\\n/\n/gs;
			$self->{$key} = $val;
		}
	}
	close(FILE);
	return 1;
	}

# Write a config file
# -------------------
sub save {
	my ($self) = @_;
	my ($key,$val,$ref);
	$self->lock();
	unless(open(FILE,"> $self->{'_file'}")) {
		$self->setErrorMessage(&main::getMessage("CONFIG_COULD_NOT_OPEN_WRITING",$self->{_file}));
		return 0;
		}
	foreach $key (keys %$self) {
		next if ($key =~ /^_/); 
		$ref = ref $self->{$key};
		if ($ref eq "ARRAY") {
			$val = "ARRAY(" . join(",",@{$self->{$key}}) . ")";
			}
		else {
			$val = $self->{$key};
			$val =~ s/\r?\n/\\n/gs;
			}
		print FILE "$key=$val\n";
		}
	close(FILE);
	$self->unlock();
	return 1;
	}
	
# Set a config value
# ------------------
sub set {
	my ($self,$key,$val) = @_;
	if (ref $key eq "SCALAR") { $key = lc($key); }
	$self->{$key} = $val;
	}

# Get a config value
# ------------------
sub get {
	my ($self,$key) = @_;
	return $self->{lc($key)};
	}

# Get all the keys in the config file
# -----------------------------------
sub keys {
	my ($self) = @_;
	my (@keys);
	foreach (keys %$self) {
		next if /^_/;
		push(@keys,$_);
		}
	return @keys;
	}

# Check if a key exists
# ---------------------
sub contains {
	my ($self,$name) = @_;
	return (defined $self->{$name});
	}

1;
