package CGISession;

sub ERROR {
	my ($msg) = @_;
	$msg = "CGISession: ";
	&main::ERROR($msg);
	}
sub FATALERROR {
	my ($msg) = @_;
	$msg = "CGISession: " . $msg;
	&main::FATALERROR($msg);
	}

sub new {
	my ($class,$dir) = @_;
	my $self = bless { }, $class;
	unless (-d $dir) {
		&FATALERROR("Session directory [$dir] is not a directory!");
		}
	unless (-w $dir) {
		&FATALERROR("Session directory [$dir] is not writeable!");
		}
	$self->{"_dir"} = $dir;
	$self->{"_expires"} = 180;
	return $self;
	}

sub Expires {
	my ($self) = shift;
	$self->{"_expires"} = shift;
	}

sub setValue {
	my ($self,$name,$value) = @_;
	$self->{$name} = $value;
	$self->{"_modified"} = 1;
	}

sub getValue {
	my ($self,$key) = @_;
	return $self->{$key};
	}

sub Exists {
	my ($self) = shift;
	if (-e $self->fileName()) { return 1; }
	return 0;
	}

sub Expired {
	my ($self) = shift;
	unless ($self->Exists()) { return 1; }
	my ($time) = -M $self->fileName();
	$time = $time * 24 * 60;
	if ($time > $self->{"_expires"}) { return 1; }
	return 0;
	}

sub isValid {
	my ($self) = shift;
	if ($self->{"_id"} !~ /^[\w\d]+$/) {
		return 0;
		}
	if ($self->isNew()) { return 1; }
	if ($self->Exists()) {
		if ($self->Expired()) {
			if (-e $self->fileName()) {
				unless(unlink($self->fileName())) {
					&ERROR("Session file [".$self->fileName()."] could not be removed.");
					return 0;
					}
				}
			return 0;
			}
		return 1;
		}
	return 0;
	}

sub fileName {
	my ($self) = shift;
	my ($file) = $self->{"_dir"};
	unless ($file =~ /\/$/) { $file .= "/"; }
	$file .= $self->{"_id"} . ".txt";
	}

sub getNewSessionID {
	my ($self) = @_;
	return abs(($$%1000) * time);
	}

sub isNew {
	my ($self) = @_;
	if ($self->{"_isnew"}) { return 1; }
	return 0;
	}

sub getSession {
	my ($self,$id) = @_;
	if ($id eq '') {
		$id = $self->getNewSessionID();
		$self->{"_isnew"} = 1;
		}
	$self->{"_id"} = $id;
	if ($self->Exists()) {
		open(IN,$self->fileName()) || &FATALERROR("Session file [".$self->fileName()."] could not be opened for reading!");
		while(<IN>) {
			chomp;
			my ($name,$value) = split(/=/);
			$self->{$name} = $value;
			}
		close(IN);
		}
	if ($self->Exists() && $self->Expired()) {
		unless(unlink($self->fileName())) {
			&ERROR("Session file [$self->fileName()] could not be removed.");
			}
		}
	}

sub saveSession {
	my ($self) = shift;
	if ($self->isValid()) {
		delete $self->{"_isnew"};
		my ($filename) = $self->fileName();
		open(OUT,"> $filename") || &FATALERROR("Session file [".$self->fileName()."] could not be opened for writing!");
		foreach $name (keys %$self) {
			print OUT "$name=".$self->{$name}."\n";
			}
		close(OUT);
		}
	}

sub ExpireNow {
	my ($self) = shift;
	if (-e $self->fileName()) {
		unlink($self->fileName());
		}
	}

sub cleanupExpiredSessions {
	my ($self) = shift;
	my ($file,$filename,$expired);
	opendir(DIR,$self->{"_dir"}) || &FATALERROR("Session directory [".$self->{_dir}."] could not be opened for reading!");
	while($file = readdir(DIR)) {
		next unless ($file =~ /\.txt$/);
		$filename = $self->{"_dir"} . $file;
		if ((-M $filename) > (($self->{'_expires'}+5)/1440)) {
			unlink($filename);
			}
		close(IN);
		}
	closedir(DIR);
	}

package main;

1;
